/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sonicscrewdrivermod.network;

import java.util.function.Supplier;
import net.mcreator.sonicscrewdrivermod.SonicScrewdriverModMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SonicScrewdriverModModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SonicScrewdriverModMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        SonicScrewdriverModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.credit_balance = message.data.credit_balance;
                    variables.head_chip = message.data.head_chip;
                    variables.hydraulic_punch = message.data.hydraulic_punch;
                    variables.steel_heart = message.data.steel_heart;
                    variables.Captain_Jack_Harkness = message.data.Captain_Jack_Harkness;
                    variables.ScrewdriverActivated = message.data.ScrewdriverActivated;
                    variables.Sonic_Setting = message.data.Sonic_Setting;
                    variables.Sonic_Pitch = message.data.Sonic_Pitch;
                    variables.SettingDisplay = message.data.SettingDisplay;
                    variables.Sonic_Limit = message.data.Sonic_Limit;
                    variables.MissyDeviceSetting = message.data.MissyDeviceSetting;
                    variables.Indigo_Device_Saved_X = message.data.Indigo_Device_Saved_X;
                    variables.Indigo_Device_Saved_Y = message.data.Indigo_Device_Saved_Y;
                    variables.Indigo_Device_Saved_Z = message.data.Indigo_Device_Saved_Z;
                    variables.IndigoDeviceTeleportType = message.data.IndigoDeviceTeleportType;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double credit_balance = 0.0;
        public double head_chip = 0.0;
        public double hydraulic_punch = 0.0;
        public double steel_heart = 0.0;
        public double Captain_Jack_Harkness = 0.0;
        public double ScrewdriverActivated = 0.0;
        public double Sonic_Setting = 0.0;
        public double Sonic_Pitch = 0.0;
        public String SettingDisplay = "\"\"";
        public double Sonic_Limit = 1.0;
        public double MissyDeviceSetting = 0.0;
        public double Indigo_Device_Saved_X = 0.0;
        public double Indigo_Device_Saved_Y = 0.0;
        public double Indigo_Device_Saved_Z = 0.0;
        public double IndigoDeviceTeleportType = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SonicScrewdriverModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("credit_balance", this.credit_balance);
            nbt.m_128347_("head_chip", this.head_chip);
            nbt.m_128347_("hydraulic_punch", this.hydraulic_punch);
            nbt.m_128347_("steel_heart", this.steel_heart);
            nbt.m_128347_("Captain_Jack_Harkness", this.Captain_Jack_Harkness);
            nbt.m_128347_("ScrewdriverActivated", this.ScrewdriverActivated);
            nbt.m_128347_("Sonic_Setting", this.Sonic_Setting);
            nbt.m_128347_("Sonic_Pitch", this.Sonic_Pitch);
            nbt.m_128359_("SettingDisplay", this.SettingDisplay);
            nbt.m_128347_("Sonic_Limit", this.Sonic_Limit);
            nbt.m_128347_("MissyDeviceSetting", this.MissyDeviceSetting);
            nbt.m_128347_("Indigo_Device_Saved_X", this.Indigo_Device_Saved_X);
            nbt.m_128347_("Indigo_Device_Saved_Y", this.Indigo_Device_Saved_Y);
            nbt.m_128347_("Indigo_Device_Saved_Z", this.Indigo_Device_Saved_Z);
            nbt.m_128347_("IndigoDeviceTeleportType", this.IndigoDeviceTeleportType);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.credit_balance = nbt.m_128459_("credit_balance");
            this.head_chip = nbt.m_128459_("head_chip");
            this.hydraulic_punch = nbt.m_128459_("hydraulic_punch");
            this.steel_heart = nbt.m_128459_("steel_heart");
            this.Captain_Jack_Harkness = nbt.m_128459_("Captain_Jack_Harkness");
            this.ScrewdriverActivated = nbt.m_128459_("ScrewdriverActivated");
            this.Sonic_Setting = nbt.m_128459_("Sonic_Setting");
            this.Sonic_Pitch = nbt.m_128459_("Sonic_Pitch");
            this.SettingDisplay = nbt.m_128461_("SettingDisplay");
            this.Sonic_Limit = nbt.m_128459_("Sonic_Limit");
            this.MissyDeviceSetting = nbt.m_128459_("MissyDeviceSetting");
            this.Indigo_Device_Saved_X = nbt.m_128459_("Indigo_Device_Saved_X");
            this.Indigo_Device_Saved_Y = nbt.m_128459_("Indigo_Device_Saved_Y");
            this.Indigo_Device_Saved_Z = nbt.m_128459_("Indigo_Device_Saved_Z");
            this.IndigoDeviceTeleportType = nbt.m_128459_("IndigoDeviceTeleportType");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("sonic_screwdriver_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "sonic_screwdriver_mod_mapvars";
        public double Torch = 0.0;
        public double stopsound = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Torch = nbt.m_128459_("Torch");
            this.stopsound = nbt.m_128459_("stopsound");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("Torch", this.Torch);
            nbt.m_128347_("stopsound", this.stopsound);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                SonicScrewdriverModMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "sonic_screwdriver_mod_worldvars";
        public double void_glasses_worn = 0.0;
        public double visited_satellite_five = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.void_glasses_worn = nbt.m_128459_("void_glasses_worn");
            this.visited_satellite_five = nbt.m_128459_("visited_satellite_five");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("void_glasses_worn", this.void_glasses_worn);
            nbt.m_128347_("visited_satellite_five", this.visited_satellite_five);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                SonicScrewdriverModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.credit_balance = original.credit_balance;
            clone.head_chip = original.head_chip;
            clone.hydraulic_punch = original.hydraulic_punch;
            clone.steel_heart = original.steel_heart;
            clone.Captain_Jack_Harkness = original.Captain_Jack_Harkness;
            clone.Sonic_Setting = original.Sonic_Setting;
            clone.Sonic_Pitch = original.Sonic_Pitch;
            clone.SettingDisplay = original.SettingDisplay;
            clone.Sonic_Limit = original.Sonic_Limit;
            clone.MissyDeviceSetting = original.MissyDeviceSetting;
            clone.Indigo_Device_Saved_X = original.Indigo_Device_Saved_X;
            clone.Indigo_Device_Saved_Y = original.Indigo_Device_Saved_Y;
            clone.Indigo_Device_Saved_Z = original.Indigo_Device_Saved_Z;
            if (!event.isWasDeath()) {
                clone.ScrewdriverActivated = original.ScrewdriverActivated;
                clone.IndigoDeviceTeleportType = original.IndigoDeviceTeleportType;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    SonicScrewdriverModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    SonicScrewdriverModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                SonicScrewdriverModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

