/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.taleofbiomes.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.nwtg.taleofbiomes.init.TaleOfBiomesModEntities;
import net.nwtg.taleofbiomes.procedures.PrairieDogEntityIsHurtProcedure;
import net.nwtg.taleofbiomes.procedures.PrairieDogLookAIConditionProcedure;
import net.nwtg.taleofbiomes.procedures.PrairieDogOnEntityTickUpdateProcedure;
import net.nwtg.taleofbiomes.procedures.PrairieDogOnInitialEntitySpawnProcedure;
import net.nwtg.taleofbiomes.procedures.PrairieDogWanderAIConditionProcedure;

public class PrairieDogEntity
extends PathfinderMob {
    public static final EntityDataAccessor<String> DATA_animation = SynchedEntityData.defineId(PrairieDogEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_animationTime = SynchedEntityData.defineId(PrairieDogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_animationTimeDefault = SynchedEntityData.defineId(PrairieDogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public PrairieDogEntity(EntityType<PrairieDogEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_animation, (Object)"normal");
        builder.define(DATA_animationTime, (Object)0);
        builder.define(DATA_animationTimeDefault, (Object)600);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal(this, 1.2){

            public boolean canUse() {
                double x = PrairieDogEntity.this.getX();
                double y = PrairieDogEntity.this.getY();
                double z = PrairieDogEntity.this.getZ();
                PrairieDogEntity entity = PrairieDogEntity.this;
                Level world = PrairieDogEntity.this.level();
                return super.canUse() && PrairieDogWanderAIConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, ServerPlayer.class, 10.0f){

            public boolean canUse() {
                double x = PrairieDogEntity.this.getX();
                double y = PrairieDogEntity.this.getY();
                double z = PrairieDogEntity.this.getZ();
                PrairieDogEntity entity = PrairieDogEntity.this;
                Level world = PrairieDogEntity.this.level();
                return super.canUse() && PrairieDogLookAIConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f){

            public boolean canUse() {
                double x = PrairieDogEntity.this.getX();
                double y = PrairieDogEntity.this.getY();
                double z = PrairieDogEntity.this.getZ();
                PrairieDogEntity entity = PrairieDogEntity.this;
                Level world = PrairieDogEntity.this.level();
                return super.canUse() && PrairieDogLookAIConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = PrairieDogEntity.this.getX();
                double y = PrairieDogEntity.this.getY();
                double z = PrairieDogEntity.this.getZ();
                PrairieDogEntity entity = PrairieDogEntity.this;
                Level world = PrairieDogEntity.this.level();
                return super.canUse() && PrairieDogWanderAIConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.jump")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        PrairieDogEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        PrairieDogEntityIsHurtProcedure.execute((Entity)entity);
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        PrairieDogOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Dataanimation", (String)this.entityData.get(DATA_animation));
        compound.putInt("DataanimationTime", ((Integer)this.entityData.get(DATA_animationTime)).intValue());
        compound.putInt("DataanimationTimeDefault", ((Integer)this.entityData.get(DATA_animationTimeDefault)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataanimation")) {
            this.entityData.set(DATA_animation, (Object)compound.getString("Dataanimation"));
        }
        if (compound.contains("DataanimationTime")) {
            this.entityData.set(DATA_animationTime, (Object)compound.getInt("DataanimationTime"));
        }
        if (compound.contains("DataanimationTimeDefault")) {
            this.entityData.set(DATA_animationTimeDefault, (Object)compound.getInt("DataanimationTimeDefault"));
        }
    }

    public void baseTick() {
        super.baseTick();
        PrairieDogOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)TaleOfBiomesModEntities.PRAIRIE_DOG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

