/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.taleofbiomes.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.nwtg.taleofbiomes.potion.EldenmoorCurseMobEffect;
import net.nwtg.taleofbiomes.procedures.EldenmoorCurseEffectExpiresProcedure;

@EventBusSubscriber
public class TaleOfBiomesModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"tale_of_biomes");
    public static final DeferredHolder<MobEffect, MobEffect> ELDENMOOR_CURSE = REGISTRY.register("eldenmoor_curse", () -> new EldenmoorCurseMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TaleOfBiomesModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TaleOfBiomesModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ELDENMOOR_CURSE)) {
            EldenmoorCurseEffectExpiresProcedure.execute(entity);
        }
    }
}

