/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.taleofbiomes.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.nwtg.taleofbiomes.TaleOfBiomesMod;
import net.nwtg.taleofbiomes.procedures.BasicStoneTableMenuHideRecipeHelperProcedure;
import net.nwtg.taleofbiomes.procedures.BasicStoneTableRecipeHelperBackButtonProcedure;
import net.nwtg.taleofbiomes.procedures.BasicStoneTableRecipeHelperNextButtonProcedure;
import net.nwtg.taleofbiomes.world.inventory.BasicStoneTableMenuRecipeBookMenu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record BasicStoneTableMenuRecipeBookButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BasicStoneTableMenuRecipeBookButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tale_of_biomes", (String)"basic_stone_table_menu_recipe_book_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BasicStoneTableMenuRecipeBookButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new BasicStoneTableMenuRecipeBookButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<BasicStoneTableMenuRecipeBookButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(BasicStoneTableMenuRecipeBookButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                BasicStoneTableMenuRecipeBookButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = BasicStoneTableMenuRecipeBookMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BasicStoneTableRecipeHelperBackButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            BasicStoneTableRecipeHelperNextButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            BasicStoneTableMenuHideRecipeHelperProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TaleOfBiomesMod.addNetworkMessage(TYPE, STREAM_CODEC, BasicStoneTableMenuRecipeBookButtonMessage::handleData);
    }
}

