/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.taleofbiomes.network;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.nwtg.taleofbiomes.TaleOfBiomesMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TaleOfBiomesModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"tale_of_biomes");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TaleOfBiomesMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        TaleOfBiomesMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tale_of_biomes", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tale_of_biomes", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public String playerSeasonName = "";
        public double blockPosX = 0.0;
        public double blockPosY = 0.0;
        public double blockPosZ = 0.0;
        public double clientTemperatureC = 0.0;
        public double clientTemperatureF = 0.0;
        public double recipePage = 0.0;
        public double recipeHelperUpdateTimer = 0.0;
        public double playerFluid = 20.0;
        public double playerFluidSaturation = 3000.0;
        public double playerFluidDamageTime = 100.0;
        public boolean CanTravelToEldenmoor = false;
        public boolean isBasicToolTableRecipeBookOpen = false;
        public boolean isRecipeHelperOpen = false;
        public ItemStack normalSlot0 = ItemStack.EMPTY;
        public ItemStack normalSlot1 = ItemStack.EMPTY;
        public ItemStack normalSlot2 = ItemStack.EMPTY;
        public ItemStack normalSlot3 = ItemStack.EMPTY;
        public ItemStack normalSlot4 = ItemStack.EMPTY;
        public ItemStack normalSlot5 = ItemStack.EMPTY;
        public ItemStack normalSlot6 = ItemStack.EMPTY;
        public ItemStack normalSlot7 = ItemStack.EMPTY;
        public ItemStack normalSlot8 = ItemStack.EMPTY;
        public ItemStack normalSlot9 = ItemStack.EMPTY;
        public ItemStack normalSlot10 = ItemStack.EMPTY;
        public ItemStack normalSlot11 = ItemStack.EMPTY;
        public ItemStack normalSlot12 = ItemStack.EMPTY;
        public ItemStack normalSlot13 = ItemStack.EMPTY;
        public ItemStack normalSlot14 = ItemStack.EMPTY;
        public ItemStack normalSlot15 = ItemStack.EMPTY;
        public ItemStack normalSlot16 = ItemStack.EMPTY;
        public ItemStack normalSlot17 = ItemStack.EMPTY;
        public ItemStack normalSlot18 = ItemStack.EMPTY;
        public ItemStack normalSlot19 = ItemStack.EMPTY;
        public ItemStack normalSlot20 = ItemStack.EMPTY;
        public ItemStack normalSlot21 = ItemStack.EMPTY;
        public ItemStack normalSlot22 = ItemStack.EMPTY;
        public ItemStack normalSlot23 = ItemStack.EMPTY;
        public ItemStack normalSlot24 = ItemStack.EMPTY;
        public ItemStack normalSlot25 = ItemStack.EMPTY;
        public ItemStack normalSlot26 = ItemStack.EMPTY;
        public ItemStack normalSlot27 = ItemStack.EMPTY;
        public ItemStack normalSlot28 = ItemStack.EMPTY;
        public ItemStack normalSlot29 = ItemStack.EMPTY;
        public ItemStack normalSlot30 = ItemStack.EMPTY;
        public ItemStack normalSlot31 = ItemStack.EMPTY;
        public ItemStack normalSlot32 = ItemStack.EMPTY;
        public ItemStack normalSlot33 = ItemStack.EMPTY;
        public ItemStack normalSlot34 = ItemStack.EMPTY;
        public ItemStack normalSlot35 = ItemStack.EMPTY;
        public ItemStack normalSlot36 = ItemStack.EMPTY;
        public ItemStack normalSlot37 = ItemStack.EMPTY;
        public ItemStack normalSlot38 = ItemStack.EMPTY;
        public ItemStack normalSlot39 = ItemStack.EMPTY;
        public ItemStack normalSlot40 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot0 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot1 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot2 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot3 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot4 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot5 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot6 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot7 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot8 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot9 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot10 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot11 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot12 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot13 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot14 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot15 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot16 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot17 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot18 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot19 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot20 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot21 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot22 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot23 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot24 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot25 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot26 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot27 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot28 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot29 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot30 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot31 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot32 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot33 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot34 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot35 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot36 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot37 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot38 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot39 = ItemStack.EMPTY;
        public ItemStack eldenmoorSlot40 = ItemStack.EMPTY;
        public double playerBiomeTemperature = 0.0;
        public double playerHeightTemperature = 0.0;
        public boolean showPlayerTemperature = false;
        public boolean playerIsSleeping = false;
        public double recipeGroup = 0.0;
        public double recipeTimer = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("playerSeasonName", this.playerSeasonName);
            nbt.putDouble("blockPosX", this.blockPosX);
            nbt.putDouble("blockPosY", this.blockPosY);
            nbt.putDouble("blockPosZ", this.blockPosZ);
            nbt.putDouble("clientTemperatureC", this.clientTemperatureC);
            nbt.putDouble("clientTemperatureF", this.clientTemperatureF);
            nbt.putDouble("recipePage", this.recipePage);
            nbt.putDouble("recipeHelperUpdateTimer", this.recipeHelperUpdateTimer);
            nbt.putDouble("playerFluid", this.playerFluid);
            nbt.putDouble("playerFluidSaturation", this.playerFluidSaturation);
            nbt.putDouble("playerFluidDamageTime", this.playerFluidDamageTime);
            nbt.putBoolean("CanTravelToEldenmoor", this.CanTravelToEldenmoor);
            nbt.putBoolean("isBasicToolTableRecipeBookOpen", this.isBasicToolTableRecipeBookOpen);
            nbt.putBoolean("isRecipeHelperOpen", this.isRecipeHelperOpen);
            nbt.put("normalSlot0", this.normalSlot0.saveOptional(lookupProvider));
            nbt.put("normalSlot1", this.normalSlot1.saveOptional(lookupProvider));
            nbt.put("normalSlot2", this.normalSlot2.saveOptional(lookupProvider));
            nbt.put("normalSlot3", this.normalSlot3.saveOptional(lookupProvider));
            nbt.put("normalSlot4", this.normalSlot4.saveOptional(lookupProvider));
            nbt.put("normalSlot5", this.normalSlot5.saveOptional(lookupProvider));
            nbt.put("normalSlot6", this.normalSlot6.saveOptional(lookupProvider));
            nbt.put("normalSlot7", this.normalSlot7.saveOptional(lookupProvider));
            nbt.put("normalSlot8", this.normalSlot8.saveOptional(lookupProvider));
            nbt.put("normalSlot9", this.normalSlot9.saveOptional(lookupProvider));
            nbt.put("normalSlot10", this.normalSlot10.saveOptional(lookupProvider));
            nbt.put("normalSlot11", this.normalSlot11.saveOptional(lookupProvider));
            nbt.put("normalSlot12", this.normalSlot12.saveOptional(lookupProvider));
            nbt.put("normalSlot13", this.normalSlot13.saveOptional(lookupProvider));
            nbt.put("normalSlot14", this.normalSlot14.saveOptional(lookupProvider));
            nbt.put("normalSlot15", this.normalSlot15.saveOptional(lookupProvider));
            nbt.put("normalSlot16", this.normalSlot16.saveOptional(lookupProvider));
            nbt.put("normalSlot17", this.normalSlot17.saveOptional(lookupProvider));
            nbt.put("normalSlot18", this.normalSlot18.saveOptional(lookupProvider));
            nbt.put("normalSlot19", this.normalSlot19.saveOptional(lookupProvider));
            nbt.put("normalSlot20", this.normalSlot20.saveOptional(lookupProvider));
            nbt.put("normalSlot21", this.normalSlot21.saveOptional(lookupProvider));
            nbt.put("normalSlot22", this.normalSlot22.saveOptional(lookupProvider));
            nbt.put("normalSlot23", this.normalSlot23.saveOptional(lookupProvider));
            nbt.put("normalSlot24", this.normalSlot24.saveOptional(lookupProvider));
            nbt.put("normalSlot25", this.normalSlot25.saveOptional(lookupProvider));
            nbt.put("normalSlot26", this.normalSlot26.saveOptional(lookupProvider));
            nbt.put("normalSlot27", this.normalSlot27.saveOptional(lookupProvider));
            nbt.put("normalSlot28", this.normalSlot28.saveOptional(lookupProvider));
            nbt.put("normalSlot29", this.normalSlot29.saveOptional(lookupProvider));
            nbt.put("normalSlot30", this.normalSlot30.saveOptional(lookupProvider));
            nbt.put("normalSlot31", this.normalSlot31.saveOptional(lookupProvider));
            nbt.put("normalSlot32", this.normalSlot32.saveOptional(lookupProvider));
            nbt.put("normalSlot33", this.normalSlot33.saveOptional(lookupProvider));
            nbt.put("normalSlot34", this.normalSlot34.saveOptional(lookupProvider));
            nbt.put("normalSlot35", this.normalSlot35.saveOptional(lookupProvider));
            nbt.put("normalSlot36", this.normalSlot36.saveOptional(lookupProvider));
            nbt.put("normalSlot37", this.normalSlot37.saveOptional(lookupProvider));
            nbt.put("normalSlot38", this.normalSlot38.saveOptional(lookupProvider));
            nbt.put("normalSlot39", this.normalSlot39.saveOptional(lookupProvider));
            nbt.put("normalSlot40", this.normalSlot40.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot0", this.eldenmoorSlot0.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot1", this.eldenmoorSlot1.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot2", this.eldenmoorSlot2.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot3", this.eldenmoorSlot3.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot4", this.eldenmoorSlot4.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot5", this.eldenmoorSlot5.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot6", this.eldenmoorSlot6.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot7", this.eldenmoorSlot7.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot8", this.eldenmoorSlot8.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot9", this.eldenmoorSlot9.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot10", this.eldenmoorSlot10.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot11", this.eldenmoorSlot11.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot12", this.eldenmoorSlot12.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot13", this.eldenmoorSlot13.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot14", this.eldenmoorSlot14.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot15", this.eldenmoorSlot15.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot16", this.eldenmoorSlot16.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot17", this.eldenmoorSlot17.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot18", this.eldenmoorSlot18.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot19", this.eldenmoorSlot19.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot20", this.eldenmoorSlot20.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot21", this.eldenmoorSlot21.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot22", this.eldenmoorSlot22.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot23", this.eldenmoorSlot23.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot24", this.eldenmoorSlot24.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot25", this.eldenmoorSlot25.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot26", this.eldenmoorSlot26.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot27", this.eldenmoorSlot27.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot28", this.eldenmoorSlot28.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot29", this.eldenmoorSlot29.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot30", this.eldenmoorSlot30.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot31", this.eldenmoorSlot31.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot32", this.eldenmoorSlot32.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot33", this.eldenmoorSlot33.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot34", this.eldenmoorSlot34.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot35", this.eldenmoorSlot35.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot36", this.eldenmoorSlot36.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot37", this.eldenmoorSlot37.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot38", this.eldenmoorSlot38.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot39", this.eldenmoorSlot39.saveOptional(lookupProvider));
            nbt.put("eldenmoorSlot40", this.eldenmoorSlot40.saveOptional(lookupProvider));
            nbt.putDouble("playerBiomeTemperature", this.playerBiomeTemperature);
            nbt.putDouble("playerHeightTemperature", this.playerHeightTemperature);
            nbt.putBoolean("showPlayerTemperature", this.showPlayerTemperature);
            nbt.putBoolean("playerIsSleeping", this.playerIsSleeping);
            nbt.putDouble("recipeGroup", this.recipeGroup);
            nbt.putDouble("recipeTimer", this.recipeTimer);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.playerSeasonName = nbt.getString("playerSeasonName");
            this.blockPosX = nbt.getDouble("blockPosX");
            this.blockPosY = nbt.getDouble("blockPosY");
            this.blockPosZ = nbt.getDouble("blockPosZ");
            this.clientTemperatureC = nbt.getDouble("clientTemperatureC");
            this.clientTemperatureF = nbt.getDouble("clientTemperatureF");
            this.recipePage = nbt.getDouble("recipePage");
            this.recipeHelperUpdateTimer = nbt.getDouble("recipeHelperUpdateTimer");
            this.playerFluid = nbt.getDouble("playerFluid");
            this.playerFluidSaturation = nbt.getDouble("playerFluidSaturation");
            this.playerFluidDamageTime = nbt.getDouble("playerFluidDamageTime");
            this.CanTravelToEldenmoor = nbt.getBoolean("CanTravelToEldenmoor");
            this.isBasicToolTableRecipeBookOpen = nbt.getBoolean("isBasicToolTableRecipeBookOpen");
            this.isRecipeHelperOpen = nbt.getBoolean("isRecipeHelperOpen");
            this.normalSlot0 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot0"));
            this.normalSlot1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot1"));
            this.normalSlot2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot2"));
            this.normalSlot3 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot3"));
            this.normalSlot4 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot4"));
            this.normalSlot5 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot5"));
            this.normalSlot6 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot6"));
            this.normalSlot7 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot7"));
            this.normalSlot8 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot8"));
            this.normalSlot9 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot9"));
            this.normalSlot10 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot10"));
            this.normalSlot11 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot11"));
            this.normalSlot12 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot12"));
            this.normalSlot13 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot13"));
            this.normalSlot14 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot14"));
            this.normalSlot15 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot15"));
            this.normalSlot16 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot16"));
            this.normalSlot17 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot17"));
            this.normalSlot18 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot18"));
            this.normalSlot19 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot19"));
            this.normalSlot20 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot20"));
            this.normalSlot21 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot21"));
            this.normalSlot22 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot22"));
            this.normalSlot23 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot23"));
            this.normalSlot24 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot24"));
            this.normalSlot25 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot25"));
            this.normalSlot26 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot26"));
            this.normalSlot27 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot27"));
            this.normalSlot28 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot28"));
            this.normalSlot29 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot29"));
            this.normalSlot30 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot30"));
            this.normalSlot31 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot31"));
            this.normalSlot32 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot32"));
            this.normalSlot33 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot33"));
            this.normalSlot34 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot34"));
            this.normalSlot35 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot35"));
            this.normalSlot36 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot36"));
            this.normalSlot37 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot37"));
            this.normalSlot38 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot38"));
            this.normalSlot39 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot39"));
            this.normalSlot40 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("normalSlot40"));
            this.eldenmoorSlot0 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot0"));
            this.eldenmoorSlot1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot1"));
            this.eldenmoorSlot2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot2"));
            this.eldenmoorSlot3 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot3"));
            this.eldenmoorSlot4 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot4"));
            this.eldenmoorSlot5 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot5"));
            this.eldenmoorSlot6 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot6"));
            this.eldenmoorSlot7 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot7"));
            this.eldenmoorSlot8 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot8"));
            this.eldenmoorSlot9 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot9"));
            this.eldenmoorSlot10 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot10"));
            this.eldenmoorSlot11 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot11"));
            this.eldenmoorSlot12 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot12"));
            this.eldenmoorSlot13 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot13"));
            this.eldenmoorSlot14 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot14"));
            this.eldenmoorSlot15 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot15"));
            this.eldenmoorSlot16 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot16"));
            this.eldenmoorSlot17 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot17"));
            this.eldenmoorSlot18 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot18"));
            this.eldenmoorSlot19 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot19"));
            this.eldenmoorSlot20 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot20"));
            this.eldenmoorSlot21 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot21"));
            this.eldenmoorSlot22 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot22"));
            this.eldenmoorSlot23 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot23"));
            this.eldenmoorSlot24 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot24"));
            this.eldenmoorSlot25 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot25"));
            this.eldenmoorSlot26 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot26"));
            this.eldenmoorSlot27 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot27"));
            this.eldenmoorSlot28 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot28"));
            this.eldenmoorSlot29 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot29"));
            this.eldenmoorSlot30 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot30"));
            this.eldenmoorSlot31 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot31"));
            this.eldenmoorSlot32 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot32"));
            this.eldenmoorSlot33 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot33"));
            this.eldenmoorSlot34 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot34"));
            this.eldenmoorSlot35 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot35"));
            this.eldenmoorSlot36 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot36"));
            this.eldenmoorSlot37 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot37"));
            this.eldenmoorSlot38 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot38"));
            this.eldenmoorSlot39 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot39"));
            this.eldenmoorSlot40 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("eldenmoorSlot40"));
            this.playerBiomeTemperature = nbt.getDouble("playerBiomeTemperature");
            this.playerHeightTemperature = nbt.getDouble("playerHeightTemperature");
            this.showPlayerTemperature = nbt.getBoolean("showPlayerTemperature");
            this.playerIsSleeping = nbt.getBoolean("playerIsSleeping");
            this.recipeGroup = nbt.getDouble("recipeGroup");
            this.recipeTimer = nbt.getDouble("recipeTimer");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "tale_of_biomes_mapvars";
        public String modNamespace = "tale_of_biomes";
        public double gnPlantTimer = 1200.0;
        public double temperatureTimer = 1.0;
        public boolean isPlayerSleeping = false;
        public double playerSleepTimer = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.modNamespace = nbt.getString("modNamespace");
            this.gnPlantTimer = nbt.getDouble("gnPlantTimer");
            this.temperatureTimer = nbt.getDouble("temperatureTimer");
            this.isPlayerSleeping = nbt.getBoolean("isPlayerSleeping");
            this.playerSleepTimer = nbt.getDouble("playerSleepTimer");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("modNamespace", this.modNamespace);
            nbt.putDouble("gnPlantTimer", this.gnPlantTimer);
            nbt.putDouble("temperatureTimer", this.temperatureTimer);
            nbt.putBoolean("isPlayerSleeping", this.isPlayerSleeping);
            nbt.putDouble("playerSleepTimer", this.playerSleepTimer);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "tale_of_biomes_worldvars";
        public String worldSeasonName = "";
        public String worldWindDirection = "";
        public double worldSeasonDay = 0.0;
        public double worldMaxSeasonDay = 0.0;
        public double worldSeasonTemperature = 0.0;
        public double worldWindSpeed = 25.0;
        public double worldWindTemperature = 0.0;
        public double worldTemperatureC = 0.0;
        public double worldTemperatureF = 0.0;
        public double worldWeatherTemperature = 0.0;
        public double worldTimeTemperature = 0.0;
        public double worldMaxWindSpeed = 50.0;
        public boolean setStartSeason = true;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.worldSeasonName = nbt.getString("worldSeasonName");
            this.worldWindDirection = nbt.getString("worldWindDirection");
            this.worldSeasonDay = nbt.getDouble("worldSeasonDay");
            this.worldMaxSeasonDay = nbt.getDouble("worldMaxSeasonDay");
            this.worldSeasonTemperature = nbt.getDouble("worldSeasonTemperature");
            this.worldWindSpeed = nbt.getDouble("worldWindSpeed");
            this.worldWindTemperature = nbt.getDouble("worldWindTemperature");
            this.worldTemperatureC = nbt.getDouble("worldTemperatureC");
            this.worldTemperatureF = nbt.getDouble("worldTemperatureF");
            this.worldWeatherTemperature = nbt.getDouble("worldWeatherTemperature");
            this.worldTimeTemperature = nbt.getDouble("worldTimeTemperature");
            this.worldMaxWindSpeed = nbt.getDouble("worldMaxWindSpeed");
            this.setStartSeason = nbt.getBoolean("setStartSeason");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("worldSeasonName", this.worldSeasonName);
            nbt.putString("worldWindDirection", this.worldWindDirection);
            nbt.putDouble("worldSeasonDay", this.worldSeasonDay);
            nbt.putDouble("worldMaxSeasonDay", this.worldMaxSeasonDay);
            nbt.putDouble("worldSeasonTemperature", this.worldSeasonTemperature);
            nbt.putDouble("worldWindSpeed", this.worldWindSpeed);
            nbt.putDouble("worldWindTemperature", this.worldWindTemperature);
            nbt.putDouble("worldTemperatureC", this.worldTemperatureC);
            nbt.putDouble("worldTemperatureF", this.worldTemperatureF);
            nbt.putDouble("worldWeatherTemperature", this.worldWeatherTemperature);
            nbt.putDouble("worldTimeTemperature", this.worldTimeTemperature);
            nbt.putDouble("worldMaxWindSpeed", this.worldMaxWindSpeed);
            nbt.putBoolean("setStartSeason", this.setStartSeason);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.recipeHelperUpdateTimer = original.recipeHelperUpdateTimer;
            clone.isBasicToolTableRecipeBookOpen = original.isBasicToolTableRecipeBookOpen;
            clone.isRecipeHelperOpen = original.isRecipeHelperOpen;
            clone.normalSlot0 = original.normalSlot0;
            clone.normalSlot1 = original.normalSlot1;
            clone.normalSlot2 = original.normalSlot2;
            clone.normalSlot3 = original.normalSlot3;
            clone.normalSlot4 = original.normalSlot4;
            clone.normalSlot5 = original.normalSlot5;
            clone.normalSlot6 = original.normalSlot6;
            clone.normalSlot7 = original.normalSlot7;
            clone.normalSlot8 = original.normalSlot8;
            clone.normalSlot9 = original.normalSlot9;
            clone.normalSlot10 = original.normalSlot10;
            clone.normalSlot11 = original.normalSlot11;
            clone.normalSlot12 = original.normalSlot12;
            clone.normalSlot13 = original.normalSlot13;
            clone.normalSlot14 = original.normalSlot14;
            clone.normalSlot15 = original.normalSlot15;
            clone.normalSlot16 = original.normalSlot16;
            clone.normalSlot17 = original.normalSlot17;
            clone.normalSlot18 = original.normalSlot18;
            clone.normalSlot19 = original.normalSlot19;
            clone.normalSlot20 = original.normalSlot20;
            clone.normalSlot21 = original.normalSlot21;
            clone.normalSlot22 = original.normalSlot22;
            clone.normalSlot23 = original.normalSlot23;
            clone.normalSlot24 = original.normalSlot24;
            clone.normalSlot25 = original.normalSlot25;
            clone.normalSlot26 = original.normalSlot26;
            clone.normalSlot27 = original.normalSlot27;
            clone.normalSlot28 = original.normalSlot28;
            clone.normalSlot29 = original.normalSlot29;
            clone.normalSlot30 = original.normalSlot30;
            clone.normalSlot31 = original.normalSlot31;
            clone.normalSlot32 = original.normalSlot32;
            clone.normalSlot33 = original.normalSlot33;
            clone.normalSlot34 = original.normalSlot34;
            clone.normalSlot35 = original.normalSlot35;
            clone.normalSlot36 = original.normalSlot36;
            clone.normalSlot37 = original.normalSlot37;
            clone.normalSlot38 = original.normalSlot38;
            clone.normalSlot39 = original.normalSlot39;
            clone.normalSlot40 = original.normalSlot40;
            clone.eldenmoorSlot0 = original.eldenmoorSlot0;
            clone.eldenmoorSlot1 = original.eldenmoorSlot1;
            clone.eldenmoorSlot2 = original.eldenmoorSlot2;
            clone.eldenmoorSlot3 = original.eldenmoorSlot3;
            clone.eldenmoorSlot4 = original.eldenmoorSlot4;
            clone.eldenmoorSlot5 = original.eldenmoorSlot5;
            clone.eldenmoorSlot6 = original.eldenmoorSlot6;
            clone.eldenmoorSlot7 = original.eldenmoorSlot7;
            clone.eldenmoorSlot8 = original.eldenmoorSlot8;
            clone.eldenmoorSlot9 = original.eldenmoorSlot9;
            clone.eldenmoorSlot10 = original.eldenmoorSlot10;
            clone.eldenmoorSlot11 = original.eldenmoorSlot11;
            clone.eldenmoorSlot12 = original.eldenmoorSlot12;
            clone.eldenmoorSlot13 = original.eldenmoorSlot13;
            clone.eldenmoorSlot14 = original.eldenmoorSlot14;
            clone.eldenmoorSlot15 = original.eldenmoorSlot15;
            clone.eldenmoorSlot16 = original.eldenmoorSlot16;
            clone.eldenmoorSlot17 = original.eldenmoorSlot17;
            clone.eldenmoorSlot18 = original.eldenmoorSlot18;
            clone.eldenmoorSlot19 = original.eldenmoorSlot19;
            clone.eldenmoorSlot20 = original.eldenmoorSlot20;
            clone.eldenmoorSlot21 = original.eldenmoorSlot21;
            clone.eldenmoorSlot22 = original.eldenmoorSlot22;
            clone.eldenmoorSlot23 = original.eldenmoorSlot23;
            clone.eldenmoorSlot24 = original.eldenmoorSlot24;
            clone.eldenmoorSlot25 = original.eldenmoorSlot25;
            clone.eldenmoorSlot26 = original.eldenmoorSlot26;
            clone.eldenmoorSlot27 = original.eldenmoorSlot27;
            clone.eldenmoorSlot28 = original.eldenmoorSlot28;
            clone.eldenmoorSlot29 = original.eldenmoorSlot29;
            clone.eldenmoorSlot30 = original.eldenmoorSlot30;
            clone.eldenmoorSlot31 = original.eldenmoorSlot31;
            clone.eldenmoorSlot32 = original.eldenmoorSlot32;
            clone.eldenmoorSlot33 = original.eldenmoorSlot33;
            clone.eldenmoorSlot34 = original.eldenmoorSlot34;
            clone.eldenmoorSlot35 = original.eldenmoorSlot35;
            clone.eldenmoorSlot36 = original.eldenmoorSlot36;
            clone.eldenmoorSlot37 = original.eldenmoorSlot37;
            clone.eldenmoorSlot38 = original.eldenmoorSlot38;
            clone.eldenmoorSlot39 = original.eldenmoorSlot39;
            clone.eldenmoorSlot40 = original.eldenmoorSlot40;
            clone.showPlayerTemperature = original.showPlayerTemperature;
            if (!event.isWasDeath()) {
                clone.playerSeasonName = original.playerSeasonName;
                clone.blockPosX = original.blockPosX;
                clone.blockPosY = original.blockPosY;
                clone.blockPosZ = original.blockPosZ;
                clone.clientTemperatureC = original.clientTemperatureC;
                clone.clientTemperatureF = original.clientTemperatureF;
                clone.recipePage = original.recipePage;
                clone.playerFluid = original.playerFluid;
                clone.playerFluidSaturation = original.playerFluidSaturation;
                clone.playerFluidDamageTime = original.playerFluidDamageTime;
                clone.CanTravelToEldenmoor = original.CanTravelToEldenmoor;
                clone.playerBiomeTemperature = original.playerBiomeTemperature;
                clone.playerHeightTemperature = original.playerHeightTemperature;
                clone.playerIsSleeping = original.playerIsSleeping;
                clone.recipeGroup = original.recipeGroup;
                clone.recipeTimer = original.recipeTimer;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

