/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.powerofenergy.network;

import java.util.function.Supplier;
import net.mcreator.powerofenergy.PowerOfEnergyMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PowerOfEnergyModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PowerOfEnergyMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Red = message.data.Red;
                    variables.Blue = message.data.Blue;
                    variables.Anim = message.data.Anim;
                    variables.Magic = message.data.Magic;
                    variables.Tehn = message.data.Tehn;
                    variables.azart1 = message.data.azart1;
                    variables.azart2 = message.data.azart2;
                    variables.azart3 = message.data.azart3;
                    variables.azcof = message.data.azcof;
                    variables.x = message.data.x;
                    variables.y = message.data.y;
                    variables.z = message.data.z;
                    variables.Plast = message.data.Plast;
                    variables.lewel = message.data.lewel;
                    variables.Lpoint = message.data.Lpoint;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Red = 100.0;
        public double Blue = 100.0;
        public double Anim = 0.0;
        public double Magic = 0.0;
        public double Tehn = 0.0;
        public double azart1 = 0.0;
        public double azart2 = 0.0;
        public double azart3 = 0.0;
        public double azcof = 0.0;
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;
        public boolean Plast = false;
        public double lewel = 1.0;
        public double Lpoint = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PowerOfEnergyMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Red", this.Red);
            nbt.m_128347_("Blue", this.Blue);
            nbt.m_128347_("Anim", this.Anim);
            nbt.m_128347_("Magic", this.Magic);
            nbt.m_128347_("Tehn", this.Tehn);
            nbt.m_128347_("azart1", this.azart1);
            nbt.m_128347_("azart2", this.azart2);
            nbt.m_128347_("azart3", this.azart3);
            nbt.m_128347_("azcof", this.azcof);
            nbt.m_128347_("x", this.x);
            nbt.m_128347_("y", this.y);
            nbt.m_128347_("z", this.z);
            nbt.m_128379_("Plast", this.Plast);
            nbt.m_128347_("lewel", this.lewel);
            nbt.m_128347_("Lpoint", this.Lpoint);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.Red = nbt.m_128459_("Red");
            this.Blue = nbt.m_128459_("Blue");
            this.Anim = nbt.m_128459_("Anim");
            this.Magic = nbt.m_128459_("Magic");
            this.Tehn = nbt.m_128459_("Tehn");
            this.azart1 = nbt.m_128459_("azart1");
            this.azart2 = nbt.m_128459_("azart2");
            this.azart3 = nbt.m_128459_("azart3");
            this.azcof = nbt.m_128459_("azcof");
            this.x = nbt.m_128459_("x");
            this.y = nbt.m_128459_("y");
            this.z = nbt.m_128459_("z");
            this.Plast = nbt.m_128471_("Plast");
            this.lewel = nbt.m_128459_("lewel");
            this.Lpoint = nbt.m_128459_("Lpoint");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("power_of_energy", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Tehn = original.Tehn;
            clone.Plast = original.Plast;
            clone.lewel = original.lewel;
            clone.Lpoint = original.Lpoint;
            if (!event.isWasDeath()) {
                clone.Red = original.Red;
                clone.Blue = original.Blue;
                clone.Anim = original.Anim;
                clone.Magic = original.Magic;
                clone.azart1 = original.azart1;
                clone.azart2 = original.azart2;
                clone.azart3 = original.azart3;
                clone.azcof = original.azcof;
                clone.x = original.x;
                clone.y = original.y;
                clone.z = original.z;
            }
        }
    }
}

