/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.legendarescreaturesdeterror.world.teleporter;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.mcreator.legendarescreaturesdeterror.init.LegendaresCreaturesDeTerrorModBlocks;
import net.mcreator.legendarescreaturesdeterror.world.teleporter.Trap3PortalShape;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Trap3Teleporter
implements ITeleporter {
    public static final TicketType<BlockPos> CUSTOM_PORTAL = TicketType.m_9465_((String)"trap_3_portal", Vec3i::compareTo, (int)300);
    public static Holder<PoiType> poi = null;
    private final ServerLevel level;
    private final BlockPos entityEnterPos;

    @SubscribeEvent
    public static void registerPointOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)LegendaresCreaturesDeTerrorModBlocks.TRAP_3_PORTAL.get()).m_49965_().m_61056_()), 0, 1);
            registerHelper.register("trap_3_portal", (Object)poiType);
            poi = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
        });
    }

    public Trap3Teleporter(ServerLevel worldServer, BlockPos entityEnterPos) {
        this.level = worldServer;
        this.entityEnterPos = entityEnterPos;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos p_192986_, boolean p_192987_, WorldBorder p_192988_) {
        PoiManager poimanager = this.level.m_8904_();
        int i = p_192987_ ? 16 : 128;
        poimanager.m_27056_((LevelReader)this.level, p_192986_, i);
        Optional<PoiRecord> optional = poimanager.m_27166_(p_230634_ -> p_230634_.m_203565_((ResourceKey)poi.m_203543_().get()), p_192986_, i, PoiManager.Occupancy.ANY).filter(p_192981_ -> p_192988_.m_61937_(p_192981_.m_27257_())).sorted(Comparator.comparingDouble(p_192984_ -> p_192984_.m_27257_().m_123331_((Vec3i)p_192986_)).thenComparingInt(p_192992_ -> p_192992_.m_27257_().m_123342_())).filter(p_192990_ -> this.level.m_8055_(p_192990_.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optional.map(p_192975_ -> {
            BlockPos blockpos = p_192975_.m_27257_();
            this.level.m_7726_().m_8387_(CUSTOM_PORTAL, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_192978_ -> this.level.m_8055_(p_192978_) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos p_77667_, Direction.Axis p_77668_) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)p_77668_);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.m_6857_();
        int i = Math.min(this.level.m_151558_(), this.level.m_141937_() + this.level.m_143344_()) - 1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_77667_.m_122032_();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.m_121935_((BlockPos)p_77667_, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockpos$mutableblockpos1.m_123341_(), blockpos$mutableblockpos1.m_123343_()));
            boolean k = true;
            if (!worldborder.m_61937_((BlockPos)blockpos$mutableblockpos1) || !worldborder.m_61937_((BlockPos)blockpos$mutableblockpos1.m_122175_(direction, 1))) continue;
            blockpos$mutableblockpos1.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= this.level.m_141937_(); --l) {
                int j1;
                blockpos$mutableblockpos1.m_142448_(l);
                if (!this.canPortalReplaceBlock(blockpos$mutableblockpos1)) continue;
                int i1 = l;
                while (l > this.level.m_141937_() && this.canPortalReplaceBlock(blockpos$mutableblockpos1.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutableblockpos1.m_142448_(l);
                if (!this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 0)) continue;
                double d2 = p_77667_.m_123331_((Vec3i)blockpos$mutableblockpos1);
                if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutableblockpos1.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutableblockpos1.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.m_141937_() - -1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockpos = new BlockPos(p_77667_.m_123341_(), Mth.m_14045_((int)p_77667_.m_123342_(), (int)k1, (int)i2), p_77667_.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            if (!worldborder.m_61937_(blockpos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockstate1 = k3 < 0 ? Blocks.f_50000_.m_49966_() : Blocks.f_50016_.m_49966_();
                        blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, j3 * direction.m_122429_() + i3 * direction1.m_122429_(), k3, j3 * direction.m_122431_() + i3 * direction1.m_122431_());
                        this.level.m_46597_((BlockPos)blockpos$mutableblockpos, blockstate1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                blockpos$mutableblockpos.m_122154_(blockpos, l1 * direction.m_122429_(), j2, l1 * direction.m_122431_());
                this.level.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50000_.m_49966_(), 3);
            }
        }
        BlockState blockstate = (BlockState)((Block)LegendaresCreaturesDeTerrorModBlocks.TRAP_3_PORTAL.get()).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)p_77668_);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, k2 * direction.m_122429_(), l2, k2 * direction.m_122431_());
                this.level.m_7731_((BlockPos)blockpos$mutableblockpos, blockstate, 18);
                this.level.m_8904_().m_217919_((BlockPos)blockpos$mutableblockpos, poi);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean canHostFrame(BlockPos p_77662_, BlockPos.MutableBlockPos p_77663_, Direction p_77664_, int p_77665_) {
        Direction direction = p_77664_.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                p_77663_.m_122154_((Vec3i)p_77662_, p_77664_.m_122429_() * i + direction.m_122429_() * p_77665_, j, p_77664_.m_122431_() * i + direction.m_122431_() * p_77665_);
                if (j < 0 && !this.level.m_8055_((BlockPos)p_77663_).m_280296_()) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(p_77663_)) continue;
                return false;
            }
        }
        return true;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel server, float yaw, Function<Boolean, Entity> repositionEntity) {
        PortalInfo portalinfo = this.getPortalInfo(entity, server);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_284127_(server);
            server.m_8817_(player);
            player.f_8906_.m_9774_(portalinfo.f_77676_.f_82479_, portalinfo.f_77676_.f_82480_, portalinfo.f_77676_.f_82481_, portalinfo.f_77678_, portalinfo.f_77679_);
            player.f_8906_.m_9953_();
            CriteriaTriggers.f_10588_.m_19757_(player, currentWorld.m_46472_(), server.m_46472_());
            return entity;
        }
        Entity entityNew = entity.m_6095_().m_20615_((Level)server);
        if (entityNew != null) {
            entityNew.m_20361_(entity);
            entityNew.m_7678_(portalinfo.f_77676_.f_82479_, portalinfo.f_77676_.f_82480_, portalinfo.f_77676_.f_82481_, portalinfo.f_77678_, entityNew.m_146909_());
            entityNew.m_20256_(portalinfo.f_77677_);
            server.m_143334_(entityNew);
        }
        return entityNew;
    }

    private PortalInfo getPortalInfo(Entity entity, ServerLevel server) {
        WorldBorder worldborder = server.m_6857_();
        double d0 = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)server.m_6042_());
        BlockPos blockpos1 = worldborder.m_187569_(entity.m_20185_() * d0, entity.m_20186_(), entity.m_20189_() * d0);
        return this.getExitPortal(entity, blockpos1, worldborder).map(repositioner -> {
            Vec3 vector3d;
            Direction.Axis direction$axis;
            BlockState blockstate = entity.m_9236_().m_8055_(this.entityEnterPos);
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                direction$axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle teleportationrepositioner$result = BlockUtil.m_124334_((BlockPos)this.entityEnterPos, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.m_9236_().m_8055_(pos) == blockstate);
                vector3d = Trap3PortalShape.getRelativePosition(teleportationrepositioner$result, direction$axis, entity.m_20182_(), entity.m_6972_(entity.m_20089_()));
            } else {
                direction$axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return Trap3PortalShape.createPortalInfo(server, repositioner, direction$axis, vector3d, entity, entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
        }).orElse(new PortalInfo(entity.m_20182_(), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_()));
    }

    protected Optional<BlockUtil.FoundRectangle> getExitPortal(Entity entity, BlockPos pos, WorldBorder worldBorder) {
        Optional<BlockUtil.FoundRectangle> optional = this.findPortalAround(pos, false, worldBorder);
        if (entity instanceof ServerPlayer) {
            if (optional.isPresent()) {
                return optional;
            }
            Direction.Axis direction$axis = entity.m_9236_().m_8055_(this.entityEnterPos).m_61145_((Property)NetherPortalBlock.f_54904_).orElse(Direction.Axis.X);
            return this.createPortal(pos, direction$axis);
        }
        return optional;
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState blockstate = this.level.m_8055_((BlockPos)pos);
        return blockstate.m_247087_() && blockstate.m_60819_().m_76178_();
    }
}

