
package net.mcreator.weapons.enchantment;

import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.entity.EquipmentSlot;

import net.mcreator.weapons.init.WeaponsModItems;

public class ReapingEnchantment extends Enchantment {
	public ReapingEnchantment(EquipmentSlot... slots) {
		super(Enchantment.Rarity.COMMON, EnchantmentCategory.BREAKABLE, slots);
	}

	@Override
	public int getMaxLevel() {
		return 2;
	}

	@Override
	public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
		return Ingredient.of(new ItemStack(WeaponsModItems.W_SY.get()), new ItemStack(WeaponsModItems.STONE_SY.get()), new ItemStack(WeaponsModItems.ISY.get()), new ItemStack(WeaponsModItems.GSY.get()), new ItemStack(WeaponsModItems.D_SY.get()),
				new ItemStack(WeaponsModItems.N_SY.get())).test(itemstack);
	}
}
