
/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.weapons.init;

import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;

import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Entity;

import net.mcreator.weapons.entity.ThorEntity;
import net.mcreator.weapons.entity.Thor2Entity;
import net.mcreator.weapons.entity.SDaggerEntity;
import net.mcreator.weapons.entity.NDaggerEntity;
import net.mcreator.weapons.entity.KingArthurEntity;
import net.mcreator.weapons.entity.IDaggerEntity;
import net.mcreator.weapons.entity.HephestusEntity;
import net.mcreator.weapons.entity.GDaggerEntity;
import net.mcreator.weapons.entity.EDaggerEntity;
import net.mcreator.weapons.entity.DaggerprojEntity;
import net.mcreator.weapons.entity.DDaggerEntity;
import net.mcreator.weapons.WeaponsMod;

@Mod.EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD)
public class WeaponsModEntities {
	public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create(ForgeRegistries.ENTITY_TYPES, WeaponsMod.MODID);
	public static final RegistryObject<EntityType<DaggerprojEntity>> DAGGERPROJ = register("daggerproj",
			EntityType.Builder.<DaggerprojEntity>of(DaggerprojEntity::new, MobCategory.MISC).setCustomClientFactory(DaggerprojEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<SDaggerEntity>> S_DAGGER = register("s_dagger",
			EntityType.Builder.<SDaggerEntity>of(SDaggerEntity::new, MobCategory.MISC).setCustomClientFactory(SDaggerEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<IDaggerEntity>> I_DAGGER = register("i_dagger",
			EntityType.Builder.<IDaggerEntity>of(IDaggerEntity::new, MobCategory.MISC).setCustomClientFactory(IDaggerEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<GDaggerEntity>> G_DAGGER = register("g_dagger",
			EntityType.Builder.<GDaggerEntity>of(GDaggerEntity::new, MobCategory.MISC).setCustomClientFactory(GDaggerEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<DDaggerEntity>> D_DAGGER = register("d_dagger",
			EntityType.Builder.<DDaggerEntity>of(DDaggerEntity::new, MobCategory.MISC).setCustomClientFactory(DDaggerEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<NDaggerEntity>> N_DAGGER = register("n_dagger",
			EntityType.Builder.<NDaggerEntity>of(NDaggerEntity::new, MobCategory.MISC).setCustomClientFactory(NDaggerEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<EDaggerEntity>> E_DAGGER = register("e_dagger",
			EntityType.Builder.<EDaggerEntity>of(EDaggerEntity::new, MobCategory.MISC).setCustomClientFactory(EDaggerEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
	public static final RegistryObject<EntityType<KingArthurEntity>> KING_ARTHUR = register("king_arthur", EntityType.Builder.<KingArthurEntity>of(KingArthurEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64)
			.setUpdateInterval(3).setCustomClientFactory(KingArthurEntity::new).fireImmune().sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<ThorEntity>> THOR = register("thor",
			EntityType.Builder.<ThorEntity>of(ThorEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ThorEntity::new)

					.sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<Thor2Entity>> THOR_2 = register("thor_2",
			EntityType.Builder.<Thor2Entity>of(Thor2Entity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Thor2Entity::new).fireImmune().sized(0.6f, 1.8f));
	public static final RegistryObject<EntityType<HephestusEntity>> HEPHESTUS = register("hephestus", EntityType.Builder.<HephestusEntity>of(HephestusEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64)
			.setUpdateInterval(3).setCustomClientFactory(HephestusEntity::new).fireImmune().sized(0.6f, 1.8f));

	private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
		return REGISTRY.register(registryname, () -> (EntityType<T>) entityTypeBuilder.build(registryname));
	}

	@SubscribeEvent
	public static void init(FMLCommonSetupEvent event) {
		event.enqueueWork(() -> {
			KingArthurEntity.init();
			ThorEntity.init();
			Thor2Entity.init();
			HephestusEntity.init();
		});
	}

	@SubscribeEvent
	public static void registerAttributes(EntityAttributeCreationEvent event) {
		event.put(KING_ARTHUR.get(), KingArthurEntity.createAttributes().build());
		event.put(THOR.get(), ThorEntity.createAttributes().build());
		event.put(THOR_2.get(), Thor2Entity.createAttributes().build());
		event.put(HEPHESTUS.get(), HephestusEntity.createAttributes().build());
	}
}
