
package net.mcreator.weapons.enchantment;

import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.entity.EquipmentSlot;

import net.mcreator.weapons.init.WeaponsModItems;

public class ReapingEnchantment extends Enchantment {
	private static final EnchantmentCategory ENCHANTMENT_CATEGORY = EnchantmentCategory.create("weapons_reaping", item -> Ingredient.of(new ItemStack(WeaponsModItems.W_SY.get()), new ItemStack(WeaponsModItems.STONE_SY.get()),
			new ItemStack(WeaponsModItems.ISY.get()), new ItemStack(WeaponsModItems.GSY.get()), new ItemStack(WeaponsModItems.D_SY.get()), new ItemStack(WeaponsModItems.N_SY.get())).test(new ItemStack(item)));

	public ReapingEnchantment() {
		super(Enchantment.Rarity.COMMON, ENCHANTMENT_CATEGORY, EquipmentSlot.values());
	}

	@Override
	public int getMinCost(int level) {
		return 1 + level * 10;
	}

	@Override
	public int getMaxCost(int level) {
		return 6 + level * 10;
	}

	@Override
	public int getMaxLevel() {
		return 2;
	}
}
