
package net.mcreator.weapons.item;

import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Item;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.tags.TagKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.core.registries.Registries;

import net.mcreator.weapons.procedures.IQShitProcedure;

public class IQSItem extends ShieldItem {
	public IQSItem(Item.Properties properties) {
		super(properties.durability(500).repairable(TagKey.create(Registries.ITEM, ResourceLocation.parse("weapons:iqs_repair_items"))));
	}

	@Override
	public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
		boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
		IQShitProcedure.execute(entity.level(), entity, itemstack);
		return retval;
	}
}
