
package net.mcreator.weapons.item;

import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Item;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.tags.TagKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.core.registries.Registries;

import net.mcreator.weapons.procedures.WQSLivingEntityIsHitWithToolProcedure;
import net.mcreator.weapons.procedures.NQShitProcedure;

public class NQSItem extends ShieldItem {
	public NQSItem(Item.Properties properties) {
		super(properties.durability(1000).repairable(TagKey.create(Registries.ITEM, ResourceLocation.parse("weapons:nqs_repair_items"))));
	}

	@Override
	public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
		boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
		WQSLivingEntityIsHitWithToolProcedure.execute(entity.level(), entity);
		return retval;
	}

	@Override
	public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
		boolean retval = super.onEntitySwing(itemstack, entity, hand);
		NQShitProcedure.execute(entity.level(), entity, itemstack);
		return retval;
	}
}
