/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewetlands.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.thewetlands.TheWetlandsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheWetlandsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheWetlandsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheWetlandsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.TimerFade = message.data.TimerFade;
                    variables.SpawnACobweb = message.data.SpawnACobweb;
                    variables.CollideWithQuagmire = message.data.CollideWithQuagmire;
                    variables.OutOfQuagmire = message.data.OutOfQuagmire;
                    variables.PlayerX = message.data.PlayerX;
                    variables.PlayerZ = message.data.PlayerZ;
                    variables.DrownPlayer = message.data.DrownPlayer;
                    variables.WearingTheBoots = message.data.WearingTheBoots;
                    variables.FOV = message.data.FOV;
                    variables.Hallucination = message.data.Hallucination;
                    variables.Hallucination_X = message.data.Hallucination_X;
                    variables.Hallucination_Z = message.data.Hallucination_Z;
                    variables.PlayerQuagmire = message.data.PlayerQuagmire;
                    variables.PlayerQuagmireKey = message.data.PlayerQuagmireKey;
                    variables.EscapeQuagmireButtonType = message.data.EscapeQuagmireButtonType;
                    variables.PlayerTouchingRoots = message.data.PlayerTouchingRoots;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double TimerFade = 0.0;
        public boolean SpawnACobweb = false;
        public boolean CollideWithQuagmire = false;
        public boolean OutOfQuagmire = false;
        public double PlayerX = 0.0;
        public double PlayerZ = 0.0;
        public double DrownPlayer = 0.0;
        public boolean WearingTheBoots = false;
        public double FOV = 0.0;
        public boolean Hallucination = false;
        public double Hallucination_X = 0.0;
        public double Hallucination_Z = 0.0;
        public double PlayerQuagmire = 0.0;
        public boolean PlayerQuagmireKey = false;
        public String EscapeQuagmireButtonType = "\"\"";
        public boolean PlayerTouchingRoots = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheWetlandsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("TimerFade", this.TimerFade);
            nbt.m_128379_("SpawnACobweb", this.SpawnACobweb);
            nbt.m_128379_("CollideWithQuagmire", this.CollideWithQuagmire);
            nbt.m_128379_("OutOfQuagmire", this.OutOfQuagmire);
            nbt.m_128347_("PlayerX", this.PlayerX);
            nbt.m_128347_("PlayerZ", this.PlayerZ);
            nbt.m_128347_("DrownPlayer", this.DrownPlayer);
            nbt.m_128379_("WearingTheBoots", this.WearingTheBoots);
            nbt.m_128347_("FOV", this.FOV);
            nbt.m_128379_("Hallucination", this.Hallucination);
            nbt.m_128347_("Hallucination_X", this.Hallucination_X);
            nbt.m_128347_("Hallucination_Z", this.Hallucination_Z);
            nbt.m_128347_("PlayerQuagmire", this.PlayerQuagmire);
            nbt.m_128379_("PlayerQuagmireKey", this.PlayerQuagmireKey);
            nbt.m_128359_("EscapeQuagmireButtonType", this.EscapeQuagmireButtonType);
            nbt.m_128379_("PlayerTouchingRoots", this.PlayerTouchingRoots);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.TimerFade = nbt.m_128459_("TimerFade");
            this.SpawnACobweb = nbt.m_128471_("SpawnACobweb");
            this.CollideWithQuagmire = nbt.m_128471_("CollideWithQuagmire");
            this.OutOfQuagmire = nbt.m_128471_("OutOfQuagmire");
            this.PlayerX = nbt.m_128459_("PlayerX");
            this.PlayerZ = nbt.m_128459_("PlayerZ");
            this.DrownPlayer = nbt.m_128459_("DrownPlayer");
            this.WearingTheBoots = nbt.m_128471_("WearingTheBoots");
            this.FOV = nbt.m_128459_("FOV");
            this.Hallucination = nbt.m_128471_("Hallucination");
            this.Hallucination_X = nbt.m_128459_("Hallucination_X");
            this.Hallucination_Z = nbt.m_128459_("Hallucination_Z");
            this.PlayerQuagmire = nbt.m_128459_("PlayerQuagmire");
            this.PlayerQuagmireKey = nbt.m_128471_("PlayerQuagmireKey");
            this.EscapeQuagmireButtonType = nbt.m_128461_("EscapeQuagmireButtonType");
            this.PlayerTouchingRoots = nbt.m_128471_("PlayerTouchingRoots");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_wetlands", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.TimerFade = original.TimerFade;
            clone.SpawnACobweb = original.SpawnACobweb;
            clone.CollideWithQuagmire = original.CollideWithQuagmire;
            clone.OutOfQuagmire = original.OutOfQuagmire;
            clone.PlayerX = original.PlayerX;
            clone.PlayerZ = original.PlayerZ;
            clone.DrownPlayer = original.DrownPlayer;
            clone.WearingTheBoots = original.WearingTheBoots;
            clone.FOV = original.FOV;
            clone.Hallucination = original.Hallucination;
            clone.Hallucination_X = original.Hallucination_X;
            clone.Hallucination_Z = original.Hallucination_Z;
            clone.PlayerQuagmire = original.PlayerQuagmire;
            clone.PlayerQuagmireKey = original.PlayerQuagmireKey;
            clone.EscapeQuagmireButtonType = original.EscapeQuagmireButtonType;
            clone.PlayerTouchingRoots = original.PlayerTouchingRoots;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }
    }
}

