/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewetlands.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.mcreator.thewetlands.network.TheWetlandsModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HallucinationBlendProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Vec3 pos = provider.getCamera().m_90583_();
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int packedLight = glowing ? 0xF000F0 : LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, blockPos), (int)level.m_45517_(LightLayer.SKY, blockPos));
        HallucinationBlendProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        HallucinationBlendProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.m_60734_();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            BlockEntity blockEntity = entityBlock.m_142194_(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.m_167982_().m_112265_(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                blockEntity.m_142339_((Level)level);
                blockEntityRenderer.m_6922_(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.m_60799_() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            BlockRenderDispatcher dispatcher = minecraft.m_91289_();
            ModelBlockRenderer renderer = dispatcher.m_110937_();
            BakedModel bakedModel = dispatcher.m_110910_(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.m_85850_();
            int color = minecraft.m_91298_().m_92582_(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.m_6299_(Sheets.m_110792_()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        if (data.containsKey(type)) {
            entity = data.get(type);
        } else {
            entity = type.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            data.put(type, entity);
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        int packedLight = glowing ? 0xF000F0 : LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, blockPos), (int)level.m_45517_(LightLayer.SKY, blockPos));
        HallucinationBlendProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(entity);
        float partialTick = provider.getPartialTick();
        int packedLight = glowing ? 0xF000F0 : renderer.m_114505_(entity, partialTick);
        HallucinationBlendProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        EntityRenderer renderer = minecraft.m_91290_().m_114382_(entity);
        Vec3 pos = provider.getCamera().m_90583_();
        float offset = entity.m_20206_() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y + (double)offset - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_252880_(0.0f, -offset, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.m_7392_(entity, entity.m_5675_(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        ItemRenderer renderer = minecraft.m_91291_();
        Vec3 pos = provider.getCamera().m_90583_();
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(x - pos.m_7096_(), y - pos.m_7098_(), z - pos.m_7094_());
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int packedLight = glowing ? 0xF000F0 : LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, blockPos), (int)level.m_45517_(LightLayer.SKY, blockPos));
        renderer.m_269491_(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)level, packedLight, OverlayTexture.f_118083_, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = provider.getCamera().m_90592_();
            Vec3 pos = entity.m_20318_(provider.getPartialTick());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            HallucinationBlendProcedure.execute((Event)provider, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(double x, double y, double z, Entity entity) {
        HallucinationBlendProcedure.execute(null, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (((TheWetlandsModVariables.PlayerVariables)entity.getCapability(TheWetlandsModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new TheWetlandsModVariables.PlayerVariables())).Hallucination) {
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + 3.0, y, z + 0.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + -3.0, y, z + 0.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + 0.0, y, z + -3.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + 0.0, y, z + 3.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + -2.0, y, z + -2.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + 2.0, y, z + 2.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + 2.0, y, z + -2.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
            HallucinationBlendProcedure.renderEntity(EntityType.f_20558_, x + -2.0, y, z + 2.0, entity.m_146908_(), entity.m_146909_(), 0.0f, 1.0f, false);
        }
    }
}

