/*
 * Decompiled with CFR 0.152.
 */
package platanitos.mod;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import platanitos.mod.init.PlatanitosModBlockEntities;
import platanitos.mod.init.PlatanitosModBlocks;
import platanitos.mod.init.PlatanitosModEnchantments;
import platanitos.mod.init.PlatanitosModEntities;
import platanitos.mod.init.PlatanitosModItems;
import platanitos.mod.init.PlatanitosModMenus;
import platanitos.mod.init.PlatanitosModMobEffects;
import platanitos.mod.init.PlatanitosModPaintings;
import platanitos.mod.init.PlatanitosModParticleTypes;
import platanitos.mod.init.PlatanitosModPotions;
import platanitos.mod.init.PlatanitosModSounds;
import platanitos.mod.init.PlatanitosModTabs;
import platanitos.mod.init.PlatanitosModVillagerProfessions;
import platanitos.mod.world.features.StructureFeature;

@Mod(value="platanitos")
public class PlatanitosMod {
    public static final Logger LOGGER = LogManager.getLogger(PlatanitosMod.class);
    public static final String MODID = "platanitos";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("platanitos", "platanitos"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public PlatanitosMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        PlatanitosModSounds.REGISTRY.register(bus);
        PlatanitosModBlocks.REGISTRY.register(bus);
        PlatanitosModBlockEntities.REGISTRY.register(bus);
        PlatanitosModItems.REGISTRY.register(bus);
        PlatanitosModEntities.REGISTRY.register(bus);
        PlatanitosModEnchantments.REGISTRY.register(bus);
        PlatanitosModTabs.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        PlatanitosModMobEffects.REGISTRY.register(bus);
        PlatanitosModPotions.REGISTRY.register(bus);
        PlatanitosModPaintings.REGISTRY.register(bus);
        PlatanitosModParticleTypes.REGISTRY.register(bus);
        PlatanitosModVillagerProfessions.PROFESSIONS.register(bus);
        PlatanitosModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

