/*
 * Decompiled with CFR 0.152.
 */
package platanitos.mod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.PlantType;
import platanitos.mod.procedures.CactiEntityWalksOnTheBlockProcedure;
import platanitos.mod.procedures.CactiPlantDestroyedByPlayerProcedure;
import platanitos.mod.procedures.RawNopalPlayerFinishesUsingItemProcedure;

public class CactiBlock
extends FlowerBlock {
    public CactiBlock() {
        super(() -> MobEffects.f_19596_, 0, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56740_).m_60966_().m_60956_(0.6f).m_60967_(0.6f).m_60910_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return CactiBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean m_6266_(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.m_60713_(Blocks.f_49992_) || groundState.m_60713_(Blocks.f_49993_);
    }

    public boolean m_7898_(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState groundState = worldIn.m_8055_(blockpos);
        return this.m_6266_(groundState, (BlockGetter)worldIn, blockpos);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(blockstate, world, pos, entity);
        RawNopalPlayerFinishesUsingItemProcedure.execute((LevelAccessor)world, entity);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        CactiPlantDestroyedByPlayerProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (Entity)entity);
        return retval;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.m_141947_(world, pos, blockstate, entity);
        CactiEntityWalksOnTheBlockProcedure.execute((LevelAccessor)world, entity);
    }
}

