/*
 * Decompiled with CFR 0.152.
 */
package net.tarotcards.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tarotcards.entity.AlienGruntEntity;
import net.tarotcards.entity.AlienRangerEntity;
import net.tarotcards.entity.InfectedAstronautEntity;
import net.tarotcards.entity.LaserEntity;
import net.tarotcards.entity.PurpleBulletEntity;
import net.tarotcards.entity.SpaceshipEntity;
import net.tarotcards.entity.TimedEventSpawnerEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TarotcardsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"tarotcards");
    public static final RegistryObject<EntityType<TimedEventSpawnerEntity>> TIMED_EVENT_SPAWNER = TarotcardsModEntities.register("timed_event_spawner", EntityType.Builder.m_20704_(TimedEventSpawnerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TimedEventSpawnerEntity::new).m_20699_(0.0f, 0.0f));
    public static final RegistryObject<EntityType<LaserEntity>> LASER = TarotcardsModEntities.register("laser", EntityType.Builder.m_20704_(LaserEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(LaserEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<InfectedAstronautEntity>> INFECTED_ASTRONAUT = TarotcardsModEntities.register("infected_astronaut", EntityType.Builder.m_20704_(InfectedAstronautEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(InfectedAstronautEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<AlienGruntEntity>> ALIEN_GRUNT = TarotcardsModEntities.register("alien_grunt", EntityType.Builder.m_20704_(AlienGruntEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AlienGruntEntity::new).m_20699_(0.9f, 2.2f));
    public static final RegistryObject<EntityType<AlienRangerEntity>> ALIEN_RANGER = TarotcardsModEntities.register("alien_ranger", EntityType.Builder.m_20704_(AlienRangerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AlienRangerEntity::new).m_20699_(0.7f, 2.2f));
    public static final RegistryObject<EntityType<PurpleBulletEntity>> PURPLE_BULLET = TarotcardsModEntities.register("purple_bullet", EntityType.Builder.m_20704_(PurpleBulletEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(PurpleBulletEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SpaceshipEntity>> SPACESHIP = TarotcardsModEntities.register("spaceship", EntityType.Builder.m_20704_(SpaceshipEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SpaceshipEntity::new).m_20699_(3.5f, 2.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TimedEventSpawnerEntity.init();
            InfectedAstronautEntity.init();
            AlienGruntEntity.init();
            AlienRangerEntity.init();
            SpaceshipEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)TIMED_EVENT_SPAWNER.get(), TimedEventSpawnerEntity.createAttributes().m_22265_());
        event.put((EntityType)INFECTED_ASTRONAUT.get(), InfectedAstronautEntity.createAttributes().m_22265_());
        event.put((EntityType)ALIEN_GRUNT.get(), AlienGruntEntity.createAttributes().m_22265_());
        event.put((EntityType)ALIEN_RANGER.get(), AlienRangerEntity.createAttributes().m_22265_());
        event.put((EntityType)SPACESHIP.get(), SpaceshipEntity.createAttributes().m_22265_());
    }
}

