
package net.mcreator.fromthedarknessitemerges.client.renderer;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.VillagerModel;

import net.mcreator.fromthedarknessitemerges.entity.ClownEntity;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.PoseStack;

public class ClownRenderer extends MobRenderer<ClownEntity, VillagerModel<ClownEntity>> {
	public ClownRenderer(EntityRendererProvider.Context context) {
		super(context, new VillagerModel(context.bakeLayer(ModelLayers.VILLAGER)), 0.5f);
		this.addLayer(new RenderLayer<ClownEntity, VillagerModel<ClownEntity>>(this) {
			final ResourceLocation LAYER_TEXTURE = new ResourceLocation("from_the_darkness_it_emerges:textures/entities/clown_entity.png");

			@Override
			public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ClownEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
				VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes(LAYER_TEXTURE));
				this.getParentModel().renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords(entity, 0), 1, 1, 1, 1);
			}
		});
	}

	@Override
	protected void scale(ClownEntity entity, PoseStack poseStack, float f) {
		poseStack.scale(0.9375f, 0.9375f, 0.9375f);
	}

	@Override
	public ResourceLocation getTextureLocation(ClownEntity entity) {
		return new ResourceLocation("from_the_darkness_it_emerges:textures/entities/clown_entity.png");
	}
}
