/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.meneerpizzashorrormod.item;

import net.mcreator.meneerpizzashorrormod.procedures.InfectteditemItemInHandTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class InfectteditemItem
extends Item {
    public InfectteditemItem() {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.COMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.fail((Object)entity.getItemInHand(hand));
        if (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY) {
            ar = InteractionResultHolder.success((Object)entity.getItemInHand(hand));
            entity.startUsingItem(hand);
        }
        InfectteditemItemInHandTickProcedure.execute((Entity)entity);
        return ar;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        InfectteditemItemInHandTickProcedure.execute((Entity)context.getPlayer());
        return InteractionResult.SUCCESS;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity) {
        boolean retval = super.onEntitySwing(itemstack, entity);
        InfectteditemItemInHandTickProcedure.execute((Entity)entity);
        return retval;
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                SpectralArrow projectile = new SpectralArrow(world, entity, stack);
                projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 3.15f, 1.0f);
                world.addFreshEntity((Entity)projectile);
                world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.5f + 1.0f));
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (stack.hurt(1, world.getRandom(), player)) {
                        stack.shrink(1);
                        stack.setDamageValue(0);
                        if (stack.isEmpty()) {
                            player.getInventory().removeItem(stack);
                        }
                    }
                } else {
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        player.getInventory().removeItem(stack);
                    }
                }
            }
        }
    }

    private ItemStack findAmmo(Player player) {
        ItemStack stack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)player, e -> e.getItem() == Items.SPECTRAL_ARROW);
        if (stack == ItemStack.EMPTY) {
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack teststack = (ItemStack)player.getInventory().items.get(i);
                if (teststack == null || teststack.getItem() != Items.SPECTRAL_ARROW) continue;
                stack = teststack;
                break;
            }
        }
        return stack;
    }
}

