/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.worldofrains.entity;

import net.mcreator.worldofrains.init.WorldOfRainsModEntities;
import net.mcreator.worldofrains.init.WorldOfRainsModItems;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RufflesEntity
extends TamableAnimal {
    public RufflesEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RufflesEntity>)((EntityType)WorldOfRainsModEntities.RUFFLES.get()), world);
    }

    public RufflesEntity(EntityType<RufflesEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 4;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WorldOfRainsModItems.WET_BUBBLE_FRUIT.get()}), false));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        return retval;
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        RufflesEntity retval = (RufflesEntity)((EntityType)WorldOfRainsModEntities.RUFFLES.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)WorldOfRainsModItems.WET_BUBBLE_FRUIT.get())}).test(stack);
    }

    public boolean m_6040_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        RufflesEntity entity = this;
        return true;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)WorldOfRainsModEntities.RUFFLES.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.7);
        builder = builder.m_22268_(Attributes.f_22276_, 13.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

