/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moretoexplore.init;

import net.mcreator.moretoexplore.entity.JadesplosionEntity;
import net.mcreator.moretoexplore.entity.WitheredCowEntity;
import net.mcreator.moretoexplore.entity.WitheredWraithEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MoreToExploreModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"more_to_explore");
    public static final DeferredHolder<EntityType<?>, EntityType<WitheredWraithEntity>> WITHERED_WRAITH = MoreToExploreModEntities.register("withered_wraith", EntityType.Builder.of(WitheredWraithEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(22).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<JadesplosionEntity>> JADESPLOSION = MoreToExploreModEntities.register("jadesplosion", EntityType.Builder.of(JadesplosionEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<WitheredCowEntity>> WITHERED_COW = MoreToExploreModEntities.register("withered_cow", EntityType.Builder.of(WitheredCowEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(SpawnPlacementRegisterEvent event) {
        WitheredWraithEntity.init(event);
        WitheredCowEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WITHERED_WRAITH.get(), WitheredWraithEntity.createAttributes().build());
        event.put((EntityType)WITHERED_COW.get(), WitheredCowEntity.createAttributes().build());
    }
}

