/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.spellbooks;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.spellbooks.init.SpellBooksModBlockEntities;
import net.mcreator.spellbooks.init.SpellBooksModBlocks;
import net.mcreator.spellbooks.init.SpellBooksModEntities;
import net.mcreator.spellbooks.init.SpellBooksModFeatures;
import net.mcreator.spellbooks.init.SpellBooksModItems;
import net.mcreator.spellbooks.init.SpellBooksModMenus;
import net.mcreator.spellbooks.init.SpellBooksModMobEffects;
import net.mcreator.spellbooks.init.SpellBooksModParticleTypes;
import net.mcreator.spellbooks.init.SpellBooksModSounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="spell_books")
public class SpellBooksMod {
    public static final Logger LOGGER = LogManager.getLogger(SpellBooksMod.class);
    public static final String MODID = "spell_books";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("spell_books", "spell_books"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SpellBooksMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SpellBooksModSounds.REGISTRY.register(bus);
        SpellBooksModBlocks.REGISTRY.register(bus);
        SpellBooksModItems.REGISTRY.register(bus);
        SpellBooksModEntities.REGISTRY.register(bus);
        SpellBooksModBlockEntities.REGISTRY.register(bus);
        SpellBooksModParticleTypes.REGISTRY.register(bus);
        SpellBooksModMobEffects.REGISTRY.register(bus);
        SpellBooksModMenus.REGISTRY.register(bus);
        SpellBooksModFeatures.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

