/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endirium.init;

import net.mcreator.endirium.entity.ElementalEntity;
import net.mcreator.endirium.entity.EnderlingBoltEntity;
import net.mcreator.endirium.entity.EnderlingEntity;
import net.mcreator.endirium.entity.GlitchedEntity;
import net.mcreator.endirium.entity.SlimmerEntity;
import net.mcreator.endirium.entity.VoidWalkerEntity;
import net.mcreator.endirium.entity.WarpedEndermanEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EndiriumModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"endirium");
    public static final RegistryObject<EntityType<GlitchedEntity>> GLITCHED = EndiriumModEntities.register("glitched", EntityType.Builder.m_20704_(GlitchedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GlitchedEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<ElementalEntity>> ELEMENTAL = EndiriumModEntities.register("elemental", EntityType.Builder.m_20704_(ElementalEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ElementalEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<WarpedEndermanEntity>> WARPED_ENDERMAN = EndiriumModEntities.register("warped_enderman", EntityType.Builder.m_20704_(WarpedEndermanEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(72).setUpdateInterval(3).setCustomClientFactory(WarpedEndermanEntity::new).m_20699_(0.6f, 3.0f));
    public static final RegistryObject<EntityType<SlimmerEntity>> SLIMMER = EndiriumModEntities.register("slimmer", EntityType.Builder.m_20704_(SlimmerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SlimmerEntity::new).m_20699_(0.6f, 0.8f));
    public static final RegistryObject<EntityType<VoidWalkerEntity>> VOID_WALKER = EndiriumModEntities.register("void_walker", EntityType.Builder.m_20704_(VoidWalkerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(VoidWalkerEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<EnderlingEntity>> ENDERLING = EndiriumModEntities.register("enderling", EntityType.Builder.m_20704_(EnderlingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).setUpdateInterval(3).setCustomClientFactory(EnderlingEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<EnderlingBoltEntity>> ENDERLING_BOLT = EndiriumModEntities.register("projectile_enderling_bolt", EntityType.Builder.m_20704_(EnderlingBoltEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(EnderlingBoltEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GlitchedEntity.init();
            ElementalEntity.init();
            WarpedEndermanEntity.init();
            SlimmerEntity.init();
            VoidWalkerEntity.init();
            EnderlingEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GLITCHED.get(), GlitchedEntity.createAttributes().m_22265_());
        event.put((EntityType)ELEMENTAL.get(), ElementalEntity.createAttributes().m_22265_());
        event.put((EntityType)WARPED_ENDERMAN.get(), WarpedEndermanEntity.m_32541_().m_22265_());
        event.put((EntityType)SLIMMER.get(), SlimmerEntity.createAttributes().m_22265_());
        event.put((EntityType)VOID_WALKER.get(), VoidWalkerEntity.createAttributes().m_22265_());
        event.put((EntityType)ENDERLING.get(), EnderlingEntity.createAttributes().m_22265_());
    }
}

