
package net.mcreator.dreamzzz.fluid;

import net.minecraftforge.fluids.ForgeFlowingFluid;

import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.LiquidBlock;

import net.mcreator.dreamzzz.init.DreamzzzModItems;
import net.mcreator.dreamzzz.init.DreamzzzModFluids;
import net.mcreator.dreamzzz.init.DreamzzzModFluidTypes;
import net.mcreator.dreamzzz.init.DreamzzzModBlocks;

public abstract class BloodFluid extends ForgeFlowingFluid {
	public static final ForgeFlowingFluid.Properties PROPERTIES = new ForgeFlowingFluid.Properties(() -> DreamzzzModFluidTypes.BLOOD_TYPE.get(), () -> DreamzzzModFluids.BLOOD.get(), () -> DreamzzzModFluids.FLOWING_BLOOD.get())
			.explosionResistance(100f).bucket(() -> DreamzzzModItems.BLOOD_BUCKET.get()).block(() -> (LiquidBlock) DreamzzzModBlocks.BLOOD.get());

	private BloodFluid() {
		super(PROPERTIES);
	}

	public static class Source extends BloodFluid {
		public int getAmount(FluidState state) {
			return 8;
		}

		public boolean isSource(FluidState state) {
			return true;
		}
	}

	public static class Flowing extends BloodFluid {
		protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
			super.createFluidStateDefinition(builder);
			builder.add(LEVEL);
		}

		public int getAmount(FluidState state) {
			return state.getValue(LEVEL);
		}

		public boolean isSource(FluidState state) {
			return false;
		}
	}
}
