
package net.mcreator.dreamzzz.block;

import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionHand;
import net.minecraft.core.Direction;
import net.minecraft.core.BlockPos;

import net.mcreator.dreamzzz.procedures.CrappyBedOnBlockRightClickedProcedure;

import java.util.List;
import java.util.Collections;

public class CrappyBedBlock extends Block {
	public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

	public CrappyBedBlock() {
		super(BlockBehaviour.Properties.of(Material.WOOD).sound(SoundType.WOOD).strength(1f, 10f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
		this.registerDefaultState(this.stateDefinition.any().setValue(FACING, Direction.NORTH));
	}

	@Override
	public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
		return true;
	}

	@Override
	public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
		return 0;
	}

	@Override
	public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
		return Shapes.empty();
	}

	@Override
	public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
		return switch (state.getValue(FACING)) {
			default -> Shapes.or(box(0.04264, 3, 16, 16.04264, 9, 32), box(0.04264, 3, -0.01472, 16.04264, 9, 15.98528), box(0.04264, -0.00761, 29, 3.04264, 2.99239, 32), box(0.04264, 0, -0.01472, 3.04264, 3, 2.98528), box(13, 0, 0, 16, 3, 3),
					box(13.04264, 0, 29, 16.04264, 3, 32));
			case NORTH -> Shapes.or(box(-0.04264, 3, -16, 15.95736, 9, 0), box(-0.04264, 3, 0.01472, 15.95736, 9, 16.01472), box(12.95736, -0.00761, -16, 15.95736, 2.99239, -13), box(12.95736, 0, 13.01472, 15.95736, 3, 16.01472),
					box(0, 0, 13, 3, 3, 16), box(-0.04264, 0, -16, 2.95736, 3, -13));
			case EAST -> Shapes.or(box(16, 3, -0.04264, 32, 9, 15.95736), box(-0.01472, 3, -0.04264, 15.98528, 9, 15.95736), box(29, -0.00761, 12.95736, 32, 2.99239, 15.95736), box(-0.01472, 0, 12.95736, 2.98528, 3, 15.95736), box(0, 0, 0, 3, 3, 3),
					box(29, 0, -0.04264, 32, 3, 2.95736));
			case WEST -> Shapes.or(box(-16, 3, 0.04264, 0, 9, 16.04264), box(0.01472, 3, 0.04264, 16.01472, 9, 16.04264), box(-16, -0.00761, 0.04264, -13, 2.99239, 3.04264), box(13.01472, 0, 0.04264, 16.01472, 3, 3.04264), box(13, 0, 13, 16, 3, 16),
					box(-16, 0, 13.04264, -13, 3, 16.04264));
		};
	}

	@Override
	protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
		builder.add(FACING);
	}

	@Override
	public BlockState getStateForPlacement(BlockPlaceContext context) {
		return this.defaultBlockState().setValue(FACING, context.getHorizontalDirection().getOpposite());
	}

	public BlockState rotate(BlockState state, Rotation rot) {
		return state.setValue(FACING, rot.rotate(state.getValue(FACING)));
	}

	public BlockState mirror(BlockState state, Mirror mirrorIn) {
		return state.rotate(mirrorIn.getRotation(state.getValue(FACING)));
	}

	@Override
	public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
		List<ItemStack> dropsOriginal = super.getDrops(state, builder);
		if (!dropsOriginal.isEmpty())
			return dropsOriginal;
		return Collections.singletonList(new ItemStack(this, 1));
	}

	@Override
	public InteractionResult use(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
		super.use(blockstate, world, pos, entity, hand, hit);
		int x = pos.getX();
		int y = pos.getY();
		int z = pos.getZ();
		double hitX = hit.getLocation().x;
		double hitY = hit.getLocation().y;
		double hitZ = hit.getLocation().z;
		Direction direction = hit.getDirection();
		CrappyBedOnBlockRightClickedProcedure.execute(entity);
		return InteractionResult.SUCCESS;
	}
}
