
package net.mcreator.dreamzzz.fluid;

import net.minecraftforge.fluids.ForgeFlowingFluid;

import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.LiquidBlock;

import net.mcreator.dreamzzz.init.DreamzzzModItems;
import net.mcreator.dreamzzz.init.DreamzzzModFluids;
import net.mcreator.dreamzzz.init.DreamzzzModFluidTypes;
import net.mcreator.dreamzzz.init.DreamzzzModBlocks;

public abstract class DreamyWaterFluid extends ForgeFlowingFluid {
	public static final ForgeFlowingFluid.Properties PROPERTIES = new ForgeFlowingFluid.Properties(() -> DreamzzzModFluidTypes.DREAMY_WATER_TYPE.get(), () -> DreamzzzModFluids.DREAMY_WATER.get(), () -> DreamzzzModFluids.FLOWING_DREAMY_WATER.get())
			.explosionResistance(100f).bucket(() -> DreamzzzModItems.DREAMY_WATER_BUCKET.get()).block(() -> (LiquidBlock) DreamzzzModBlocks.DREAMY_WATER.get());

	private DreamyWaterFluid() {
		super(PROPERTIES);
	}

	public static class Source extends DreamyWaterFluid {
		public int getAmount(FluidState state) {
			return 8;
		}

		public boolean isSource(FluidState state) {
			return true;
		}
	}

	public static class Flowing extends DreamyWaterFluid {
		protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
			super.createFluidStateDefinition(builder);
			builder.add(LEVEL);
		}

		public int getAmount(FluidState state) {
			return state.getValue(LEVEL);
		}

		public boolean isSource(FluidState state) {
			return false;
		}
	}
}
