/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.herioshelianmod.entity;

import java.util.function.Predicate;
import net.mcreator.herioshelianmod.init.HeriosHelianModModItems;
import net.mcreator.herioshelianmod.procedures.HelianEntityIsHurtProcedure;
import net.mcreator.herioshelianmod.procedures.HelianModelVisualScaleProcedure;
import net.mcreator.herioshelianmod.procedures.HelianTrustFalseProcedure;
import net.mcreator.herioshelianmod.procedures.IdlePlaybackConditionProcedure;
import net.mcreator.herioshelianmod.procedures.WalkingPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class HelianwarriorEntity
extends PathfinderMob {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public HelianwarriorEntity(EntityType<HelianwarriorEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, this, 1.5, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false){

            public boolean canUse() {
                double x = HelianwarriorEntity.this.getX();
                double y = HelianwarriorEntity.this.getY();
                double z = HelianwarriorEntity.this.getZ();
                HelianwarriorEntity entity = HelianwarriorEntity.this;
                Level world = HelianwarriorEntity.this.level();
                return super.canUse() && HelianTrustFalseProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = HelianwarriorEntity.this.getX();
                double y = HelianwarriorEntity.this.getY();
                double z = HelianwarriorEntity.this.getZ();
                HelianwarriorEntity entity = HelianwarriorEntity.this;
                Level world = HelianwarriorEntity.this.level();
                return super.canContinueToUse() && HelianTrustFalseProcedure.execute((LevelAccessor)world);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, true, false){

            public boolean canUse() {
                double x = HelianwarriorEntity.this.getX();
                double y = HelianwarriorEntity.this.getY();
                double z = HelianwarriorEntity.this.getZ();
                HelianwarriorEntity entity = HelianwarriorEntity.this;
                Level world = HelianwarriorEntity.this.level();
                return super.canUse() && HelianTrustFalseProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = HelianwarriorEntity.this.getX();
                double y = HelianwarriorEntity.this.getY();
                double z = HelianwarriorEntity.this.getZ();
                HelianwarriorEntity entity = HelianwarriorEntity.this;
                Level world = HelianwarriorEntity.this.level();
                return super.canContinueToUse() && HelianTrustFalseProcedure.execute((LevelAccessor)world);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)HeriosHelianModModItems.WELCOMEHELIAN.get()}), false));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"herios_helian_mod:helian.ambience"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"herios_helian_mod:helian.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"herios_helian_mod:helian.hurt"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        HelianwarriorEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        HelianEntityIsHurtProcedure.execute((LevelAccessor)world, sourceentity);
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(WalkingPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        HelianwarriorEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)HelianModelVisualScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 17.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        return builder;
    }
}

