/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.mcreator.generatorcraft.procedures.ReturnBigGemDescriptionProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BigGemBlock
extends FallingBlock {
    public static final MapCodec<BigGemBlock> CODEC = BigGemBlock.simpleCodec(BigGemBlock::new);

    public MapCodec<BigGemBlock> codec() {
        return CODEC;
    }

    public BigGemBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.HAT).sound(SoundType.GLASS).strength(1.0f, 0.4f).noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        Entity entity = itemstack.getEntityRepresentation() != null ? itemstack.getEntityRepresentation() : Minecraft.getInstance().player;
        String hoverText = ReturnBigGemDescriptionProcedure.execute((LevelAccessor)entity.level());
        if (hoverText != null) {
            for (String line : hoverText.split("\n")) {
                list.add((Component)Component.literal((String)line));
            }
        }
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)BigGemBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), (VoxelShape[])new VoxelShape[]{BigGemBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), BigGemBlock.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), BigGemBlock.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), BigGemBlock.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), BigGemBlock.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), BigGemBlock.box((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), BigGemBlock.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0)});
    }
}

