/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.block;

import java.util.List;
import net.mcreator.generatorcraft.block.entity.GemstoneObeliskBlockEntity;
import net.mcreator.generatorcraft.procedures.GemstoneObeliskBlockAddedProcedure;
import net.mcreator.generatorcraft.procedures.GemstoneObeliskClaimProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GemstoneObeliskBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public GemstoneObeliskBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.HAT).sound(SoundType.METAL).strength(4.0f, 3.7E7f).lightLevel(s -> 15).noOcclusion().pushReaction(PushReaction.DESTROY).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.generatorcraft.gemstone_obelisk.description_0"));
        list.add((Component)Component.translatable((String)"block.generatorcraft.gemstone_obelisk.description_1"));
        list.add((Component)Component.translatable((String)"block.generatorcraft.gemstone_obelisk.description_2"));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)GemstoneObeliskBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{GemstoneObeliskBlock.box((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)29.0, (double)15.0), GemstoneObeliskBlock.box((double)2.0, (double)29.0, (double)2.0, (double)14.0, (double)30.0, (double)14.0), GemstoneObeliskBlock.box((double)4.0, (double)30.0, (double)4.0, (double)12.0, (double)31.0, (double)12.0), GemstoneObeliskBlock.box((double)6.0, (double)31.0, (double)6.0, (double)10.0, (double)32.0, (double)10.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)GemstoneObeliskBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{GemstoneObeliskBlock.box((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)29.0, (double)15.0), GemstoneObeliskBlock.box((double)2.0, (double)29.0, (double)2.0, (double)14.0, (double)30.0, (double)14.0), GemstoneObeliskBlock.box((double)4.0, (double)30.0, (double)4.0, (double)12.0, (double)31.0, (double)12.0), GemstoneObeliskBlock.box((double)6.0, (double)31.0, (double)6.0, (double)10.0, (double)32.0, (double)10.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)GemstoneObeliskBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{GemstoneObeliskBlock.box((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)29.0, (double)15.0), GemstoneObeliskBlock.box((double)2.0, (double)29.0, (double)2.0, (double)14.0, (double)30.0, (double)14.0), GemstoneObeliskBlock.box((double)4.0, (double)30.0, (double)4.0, (double)12.0, (double)31.0, (double)12.0), GemstoneObeliskBlock.box((double)6.0, (double)31.0, (double)6.0, (double)10.0, (double)32.0, (double)10.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)GemstoneObeliskBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{GemstoneObeliskBlock.box((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)29.0, (double)15.0), GemstoneObeliskBlock.box((double)2.0, (double)29.0, (double)2.0, (double)14.0, (double)30.0, (double)14.0), GemstoneObeliskBlock.box((double)4.0, (double)30.0, (double)4.0, (double)12.0, (double)31.0, (double)12.0), GemstoneObeliskBlock.box((double)6.0, (double)31.0, (double)6.0, (double)10.0, (double)32.0, (double)10.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        GemstoneObeliskBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        GemstoneObeliskClaimProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GemstoneObeliskBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }
}

