/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.block;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.mcreator.generatorcraft.block.entity.UltraAnvilBlockEntity;
import net.mcreator.generatorcraft.world.inventory.CustomAnvilGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class UltraAnvilBlock
extends FallingBlock
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<UltraAnvilBlock> CODEC = UltraAnvilBlock.simpleCodec(UltraAnvilBlock::new);

    public MapCodec<UltraAnvilBlock> codec() {
        return CODEC;
    }

    public UltraAnvilBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.ANVIL).strength(7.0f, 1500.0f).noOcclusion().pushReaction(PushReaction.IGNORE).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.generatorcraft.ultra_anvil.description_0"));
        list.add((Component)Component.translatable((String)"block.generatorcraft.ultra_anvil.description_1"));
        list.add((Component)Component.translatable((String)"block.generatorcraft.ultra_anvil.description_2"));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)UltraAnvilBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape[])new VoxelShape[]{UltraAnvilBlock.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), UltraAnvilBlock.box((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)10.0, (double)12.0), UltraAnvilBlock.box((double)2.0, (double)10.0, (double)0.0, (double)14.0, (double)17.0, (double)16.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)UltraAnvilBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape[])new VoxelShape[]{UltraAnvilBlock.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), UltraAnvilBlock.box((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)10.0, (double)12.0), UltraAnvilBlock.box((double)2.0, (double)10.0, (double)0.0, (double)14.0, (double)17.0, (double)16.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)UltraAnvilBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape[])new VoxelShape[]{UltraAnvilBlock.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), UltraAnvilBlock.box((double)4.0, (double)5.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), UltraAnvilBlock.box((double)0.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)14.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)UltraAnvilBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape[])new VoxelShape[]{UltraAnvilBlock.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), UltraAnvilBlock.box((double)4.0, (double)5.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), UltraAnvilBlock.box((double)0.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)14.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Ultra Anvil");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new CustomAnvilGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UltraAnvilBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof UltraAnvilBlockEntity) {
                UltraAnvilBlockEntity be = (UltraAnvilBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof UltraAnvilBlockEntity) {
            UltraAnvilBlockEntity be = (UltraAnvilBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

