/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.generatorcraft.network.BankGUIButtonMessage;
import net.mcreator.generatorcraft.procedures.ReturnBankCoinsProcedure;
import net.mcreator.generatorcraft.procedures.ReturnBankGemsProcedure;
import net.mcreator.generatorcraft.procedures.ReturnBankLevelProcedure;
import net.mcreator.generatorcraft.procedures.ReturnBankUpgradePriceProcedure;
import net.mcreator.generatorcraft.procedures.ReturnPlayerProcedure;
import net.mcreator.generatorcraft.world.inventory.BankGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BankGUIScreen
extends AbstractContainerScreen<BankGUIMenu> {
    private static final HashMap<String, Object> guistate = BankGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_upgrade;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"generatorcraft:textures/screens/bank_gui.png");

    public BankGUIScreen(BankGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ReturnPlayerProcedure.execute((Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 151, this.topPos + 72, 30, 0.0f + (float)Math.atan((double)(this.leftPos + 151 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 23 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, ReturnBankCoinsProcedure.execute((Entity)this.entity), 6, 16, -13312, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.bank_gui.label_bank"), 6, 7, -12829636, false);
        guiGraphics.drawString(this.font, ReturnBankGemsProcedure.execute((Entity)this.entity), 6, 25, -13382656, false);
        guiGraphics.drawString(this.font, ReturnBankLevelProcedure.execute((Entity)this.entity), 6, 34, -39322, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.bank_gui.label_bank_withdrawdepositopen_c"), -30, -20, -1, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.bank_gui.label_upgrade_bank_half_of_max_curre"), 6, 43, -12829636, false);
        guiGraphics.drawString(this.font, ReturnBankUpgradePriceProcedure.execute((LevelAccessor)this.world, (Entity)this.entity), 6, 52, -12829636, false);
    }

    public void init() {
        super.init();
        this.button_upgrade = Button.builder((Component)Component.translatable((String)"gui.generatorcraft.bank_gui.button_upgrade"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new BankGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            BankGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 6, this.topPos + 61, 61, 20).build();
        guistate.put("button:button_upgrade", this.button_upgrade);
        this.addRenderableWidget((GuiEventListener)this.button_upgrade);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

