/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.generatorcraft.network.RebirthGUIButtonMessage;
import net.mcreator.generatorcraft.procedures.ReturnCurrentRebirthBoostProcedure;
import net.mcreator.generatorcraft.procedures.ReturnCurrentRebirthsProcedure;
import net.mcreator.generatorcraft.procedures.ReturnPlayerProcedure;
import net.mcreator.generatorcraft.procedures.ReturnRebirthRequirementProcedure;
import net.mcreator.generatorcraft.world.inventory.RebirthGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RebirthGUIScreen
extends AbstractContainerScreen<RebirthGUIMenu> {
    private static final HashMap<String, Object> guistate = RebirthGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_buy;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"generatorcraft:textures/screens/rebirth_gui.png");

    public RebirthGUIScreen(RebirthGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 280;
        this.imageHeight = 230;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ReturnPlayerProcedure.execute((Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 151, this.topPos + 188, 30, 0.0f + (float)Math.atan((double)(this.leftPos + 151 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 139 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(RenderType::guiTextured, ResourceLocation.parse((String)"generatorcraft:textures/screens/rebirth_img.png"), this.leftPos + 218, this.topPos + 11, 0.0f, 0.0f, 50, 50, 50, 50);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_would_you_like_to_unlock"), 4, 3, -12829636, false);
        guiGraphics.drawString(this.font, ReturnCurrentRebirthsProcedure.execute((Entity)this.entity), 4, 18, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_would_you_like_to_rebirth"), 4, 63, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_this_will_reset_your_generatorc"), 4, 78, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_advancements_shop_upgrades"), 4, 93, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_generatorcraft_levels_and_stats"), 4, 108, -12829636, false);
        guiGraphics.drawString(this.font, ReturnCurrentRebirthBoostProcedure.execute((Entity)this.entity), 4, 33, -12829636, false);
        guiGraphics.drawString(this.font, ReturnRebirthRequirementProcedure.execute((Entity)this.entity), 4, 213, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_rebirthing_will_add_01_to_your"), 4, 138, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.label_to_your_rebirth_boost"), 4, 153, -12829636, false);
    }

    public void init() {
        super.init();
        this.button_buy = Button.builder((Component)Component.translatable((String)"gui.generatorcraft.rebirth_gui.button_buy"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new RebirthGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RebirthGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 235, this.topPos + 206, 40, 20).build();
        guistate.put("button:button_buy", this.button_buy);
        this.addRenderableWidget((GuiEventListener)this.button_buy);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

