/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.init;

import net.mcreator.generatorcraft.entity.MoneySheepEntity;
import net.mcreator.generatorcraft.entity.WealthyCreeperEntity;
import net.mcreator.generatorcraft.entity.WealthySkeletonEntity;
import net.mcreator.generatorcraft.entity.WealthyZombieEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GeneratorcraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"generatorcraft");
    public static final DeferredHolder<EntityType<?>, EntityType<MoneySheepEntity>> MONEY_SHEEP = GeneratorcraftModEntities.register("money_sheep", EntityType.Builder.of(MoneySheepEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<WealthyZombieEntity>> WEALTHY_ZOMBIE = GeneratorcraftModEntities.register("wealthy_zombie", EntityType.Builder.of(WealthyZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<WealthySkeletonEntity>> WEALTHY_SKELETON = GeneratorcraftModEntities.register("wealthy_skeleton", EntityType.Builder.of(WealthySkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<WealthyCreeperEntity>> WEALTHY_CREEPER = GeneratorcraftModEntities.register("wealthy_creeper", EntityType.Builder.of(WealthyCreeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MoneySheepEntity.init(event);
        WealthyZombieEntity.init(event);
        WealthySkeletonEntity.init(event);
        WealthyCreeperEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MONEY_SHEEP.get(), MoneySheepEntity.createAttributes().build());
        event.put((EntityType)WEALTHY_ZOMBIE.get(), WealthyZombieEntity.createAttributes().build());
        event.put((EntityType)WEALTHY_SKELETON.get(), WealthySkeletonEntity.createAttributes().build());
        event.put((EntityType)WEALTHY_CREEPER.get(), WealthyCreeperEntity.createAttributes().build());
    }
}

