/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.HashMap;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.mcreator.generatorcraft.procedures.DevBecomeOpProcedure;
import net.mcreator.generatorcraft.procedures.DevGamemodeSwitcherProcedure;
import net.mcreator.generatorcraft.procedures.DevIgnoreCooldownsButtonProcedure;
import net.mcreator.generatorcraft.procedures.DevIgnoreLimitsButtonProcedure;
import net.mcreator.generatorcraft.procedures.DevModifyButtonProcedure;
import net.mcreator.generatorcraft.procedures.DevToTimeButtonProcedure;
import net.mcreator.generatorcraft.world.inventory.DevGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DevGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DevGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)"dev_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DevGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new DevGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<DevGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(DevGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                DevGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = DevGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            DevModifyButtonProcedure.execute((LevelAccessor)world, (Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DevIgnoreLimitsButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            DevBecomeOpProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            DevGamemodeSwitcherProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DevIgnoreCooldownsButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            DevToTimeButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(TYPE, STREAM_CODEC, DevGUIButtonMessage::handleData);
    }
}

