/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.HashMap;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.mcreator.generatorcraft.procedures.BACKBUTTONProcedure;
import net.mcreator.generatorcraft.procedures.BuyBigGemProcedure;
import net.mcreator.generatorcraft.procedures.BuyClonePotionProcedure;
import net.mcreator.generatorcraft.procedures.BuyDuperProcedure;
import net.mcreator.generatorcraft.procedures.BuyGamblecoreDiscProcedure;
import net.mcreator.generatorcraft.procedures.BuyGargantuanXPElixirProcedure;
import net.mcreator.generatorcraft.procedures.BuyGemArmorToolsProcedure;
import net.mcreator.generatorcraft.procedures.BuyGemstoneObeliskProcedure;
import net.mcreator.generatorcraft.procedures.BuyOmgeaFuelProcedure;
import net.mcreator.generatorcraft.procedures.BuyTotemOfWealthProcedure;
import net.mcreator.generatorcraft.procedures.BuyUltraAnvilProcedure;
import net.mcreator.generatorcraft.world.inventory.GemShopGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record GemShopGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GemShopGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)"gem_shop_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GemShopGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new GemShopGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GemShopGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(GemShopGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GemShopGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GemShopGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BACKBUTTONProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            BuyBigGemProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            BuyDuperProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            BuyGemArmorToolsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            BuyGamblecoreDiscProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            BuyClonePotionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            BuyUltraAnvilProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            BuyOmgeaFuelProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            BuyGargantuanXPElixirProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            BuyGemstoneObeliskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            BuyTotemOfWealthProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(TYPE, STREAM_CODEC, GemShopGUIButtonMessage::handleData);
    }
}

