/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.function.Supplier;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GeneratorcraftModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"generatorcraft");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        GeneratorcraftMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double coins = 0.0;
        public double gems = 0.0;
        public boolean ValueOverlayShown = true;
        public double coin_chance = 1.0;
        public double box_chance = 10.0;
        public double coin_multiplier = 1.0;
        public double combat_log_timer = 0.0;
        public boolean combat_logged = false;
        public double held_box_rarity = 0.0;
        public double opened_box_rarity = 0.0;
        public double upgrade_coin_chance_cost = 10.0;
        public double upgrade_box_chance_cost = 500.0;
        public double upgrade_coin_multiplayer_cost = 5000.0;
        public double gem_chance = 0.0;
        public double gem_chance_upgrade_cost = 10000.0;
        public ItemStack gamble_slot_0 = ItemStack.EMPTY;
        public ItemStack gamble_slot_1 = ItemStack.EMPTY;
        public ItemStack gamble_slot_2 = ItemStack.EMPTY;
        public double slots_forgive = 0.0;
        public boolean slots_rolling = false;
        public boolean slots_unlocked = false;
        public double combat_log_time = 100.0;
        public double upgrade_combat_log_time_cost = 500.0;
        public double combat_log_time_seconds = 0.0;
        public boolean debug_overlay_shown = false;
        public ItemStack lootbox_item = ItemStack.EMPTY;
        public boolean watermark_funny = true;
        public double slot_thing = 1.0;
        public double dice_roll = 0.0;
        public boolean is_ad_active_right_now = false;
        public double ad_time_until_skip = 0.0;
        public boolean adblock_enabled = false;
        public boolean can_skip_ad = false;
        public double time_until_ad_ticks = 0.0;
        public double time_until_ad_seconds = 0.0;
        public double time_until_ad_minutes = 0.0;
        public double ad_time_until_skip_seconds = 0.0;
        public boolean tips_enabled = true;
        public boolean captcha_active = false;
        public double human_number_1 = 0.0;
        public double human_number_2 = 0.0;
        public double human_number_3 = 0.0;
        public double GC_LEVEL = 1.0;
        public String level_color = "white";
        public String gc_team_name = "none";
        public String player_username = "\"\"";
        public boolean gc_team_active = false;
        public double gc_current_xp = 1.0;
        public double gc_total_xp = 1.0;
        public double max_coins = 1000.0;
        public double max_gems = 1000.0;
        public boolean bank_unlocked = false;
        public double coins_in_bank = 0.0;
        public double gems_in_bank = 0.0;
        public double max_coins_in_bank = 0.0;
        public double max_gems_in_bank = 0.0;
        public double bank_level = 0.0;
        public boolean ignore_limits_dev = false;
        public boolean know_how_to_play = false;
        public boolean ignore_cooldowns_dev = false;
        public boolean forgive_claimed = false;
        public boolean daily_collected = false;
        public double slot_spins = 0.0;
        public double daily_reminder_clock = 0.0;
        public boolean daily_reminder_action = false;
        public double split_event_difficulty = 0.0;
        public String split_lastmove = "";
        public String split_move1 = "";
        public String split_move2 = "";
        public String split_move3 = "";
        public String split_move4 = "";
        public String split_move5 = "";
        public String split_move6 = "";
        public String split_move7 = "";
        public String split_move8 = "";
        public String split_lastmove_npc = "";
        public String split_move1_npc = "";
        public String split_move2_npc = "";
        public String split_move3_npc = "";
        public String split_move4_npc = "";
        public String split_move5_npc = "";
        public String split_move6_npc = "";
        public String split_move7_npc = "";
        public String split_move8_npc = "";
        public double split_round = 0.0;
        public boolean split_npc_decided = false;
        public boolean split_player_move = false;
        public double split_total = 0.0;
        public double split_toplayer = 0.0;
        public double split_tonpc = 0.0;
        public boolean box_chance_logic = true;
        public boolean duper_cooldown_active = false;
        public double duper_cooldown_clock_ticks = 72000.0;
        public String panel_viewing_ign = "\"\"";
        public double panel_coins = 0.0;
        public double panel_max_coins = 0.0;
        public double panel_coins_in_bank = 0.0;
        public double panel_max_coins_in_bank = 0.0;
        public double panel_gems = 0.0;
        public double panel_max_gems = 0.0;
        public double panel_gems_in_bank = 0.0;
        public double panel_max_gems_in_bank = 0.0;
        public double panel_coin_chance = 0.0;
        public double panel_gem_chance = 0.0;
        public double panel_box_chance = 0.0;
        public double panel_coin_multiplier = 0.0;
        public boolean panel_slots_unlocked = false;
        public double panel_slot_spins = 0.0;
        public boolean panel_watermark_funny = false;
        public boolean panel_adblock_enabled = false;
        public boolean panel_bank_unlocked = false;
        public double price_multiplier = 1.0;
        public double upgrade_price_multiplier_cost = 0.0;
        public boolean price_mp_fixed = false;
        public double rebirths = 0.0;
        public double rebirth_boost = 0.0;
        public boolean rebirth_notify = false;
        public double debt_to_world_bank = 0.0;
        public double debt_timer_ticks = 0.0;
        public double debt_timer_seconds = 0.0;
        public double bad_debt_timer = 0.0;
        public boolean failed_to_repay_debt = false;
        public boolean is_loaning = false;
        public double emptix_tokens = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("coins", this.coins);
            nbt.putDouble("gems", this.gems);
            nbt.putBoolean("ValueOverlayShown", this.ValueOverlayShown);
            nbt.putDouble("coin_chance", this.coin_chance);
            nbt.putDouble("box_chance", this.box_chance);
            nbt.putDouble("coin_multiplier", this.coin_multiplier);
            nbt.putDouble("combat_log_timer", this.combat_log_timer);
            nbt.putBoolean("combat_logged", this.combat_logged);
            nbt.putDouble("held_box_rarity", this.held_box_rarity);
            nbt.putDouble("opened_box_rarity", this.opened_box_rarity);
            nbt.putDouble("upgrade_coin_chance_cost", this.upgrade_coin_chance_cost);
            nbt.putDouble("upgrade_box_chance_cost", this.upgrade_box_chance_cost);
            nbt.putDouble("upgrade_coin_multiplayer_cost", this.upgrade_coin_multiplayer_cost);
            nbt.putDouble("gem_chance", this.gem_chance);
            nbt.putDouble("gem_chance_upgrade_cost", this.gem_chance_upgrade_cost);
            nbt.put("gamble_slot_0", this.gamble_slot_0.saveOptional(lookupProvider));
            nbt.put("gamble_slot_1", this.gamble_slot_1.saveOptional(lookupProvider));
            nbt.put("gamble_slot_2", this.gamble_slot_2.saveOptional(lookupProvider));
            nbt.putDouble("slots_forgive", this.slots_forgive);
            nbt.putBoolean("slots_rolling", this.slots_rolling);
            nbt.putBoolean("slots_unlocked", this.slots_unlocked);
            nbt.putDouble("combat_log_time", this.combat_log_time);
            nbt.putDouble("upgrade_combat_log_time_cost", this.upgrade_combat_log_time_cost);
            nbt.putDouble("combat_log_time_seconds", this.combat_log_time_seconds);
            nbt.putBoolean("debug_overlay_shown", this.debug_overlay_shown);
            nbt.put("lootbox_item", this.lootbox_item.saveOptional(lookupProvider));
            nbt.putBoolean("watermark_funny", this.watermark_funny);
            nbt.putDouble("slot_thing", this.slot_thing);
            nbt.putDouble("dice_roll", this.dice_roll);
            nbt.putBoolean("is_ad_active_right_now", this.is_ad_active_right_now);
            nbt.putDouble("ad_time_until_skip", this.ad_time_until_skip);
            nbt.putBoolean("adblock_enabled", this.adblock_enabled);
            nbt.putBoolean("can_skip_ad", this.can_skip_ad);
            nbt.putDouble("time_until_ad_ticks", this.time_until_ad_ticks);
            nbt.putDouble("time_until_ad_seconds", this.time_until_ad_seconds);
            nbt.putDouble("time_until_ad_minutes", this.time_until_ad_minutes);
            nbt.putDouble("ad_time_until_skip_seconds", this.ad_time_until_skip_seconds);
            nbt.putBoolean("tips_enabled", this.tips_enabled);
            nbt.putBoolean("captcha_active", this.captcha_active);
            nbt.putDouble("human_number_1", this.human_number_1);
            nbt.putDouble("human_number_2", this.human_number_2);
            nbt.putDouble("human_number_3", this.human_number_3);
            nbt.putDouble("GC_LEVEL", this.GC_LEVEL);
            nbt.putString("level_color", this.level_color);
            nbt.putString("gc_team_name", this.gc_team_name);
            nbt.putString("player_username", this.player_username);
            nbt.putBoolean("gc_team_active", this.gc_team_active);
            nbt.putDouble("gc_current_xp", this.gc_current_xp);
            nbt.putDouble("gc_total_xp", this.gc_total_xp);
            nbt.putDouble("max_coins", this.max_coins);
            nbt.putDouble("max_gems", this.max_gems);
            nbt.putBoolean("bank_unlocked", this.bank_unlocked);
            nbt.putDouble("coins_in_bank", this.coins_in_bank);
            nbt.putDouble("gems_in_bank", this.gems_in_bank);
            nbt.putDouble("max_coins_in_bank", this.max_coins_in_bank);
            nbt.putDouble("max_gems_in_bank", this.max_gems_in_bank);
            nbt.putDouble("bank_level", this.bank_level);
            nbt.putBoolean("ignore_limits_dev", this.ignore_limits_dev);
            nbt.putBoolean("know_how_to_play", this.know_how_to_play);
            nbt.putBoolean("ignore_cooldowns_dev", this.ignore_cooldowns_dev);
            nbt.putBoolean("forgive_claimed", this.forgive_claimed);
            nbt.putBoolean("daily_collected", this.daily_collected);
            nbt.putDouble("slot_spins", this.slot_spins);
            nbt.putDouble("daily_reminder_clock", this.daily_reminder_clock);
            nbt.putBoolean("daily_reminder_action", this.daily_reminder_action);
            nbt.putDouble("split_event_difficulty", this.split_event_difficulty);
            nbt.putString("split_lastmove", this.split_lastmove);
            nbt.putString("split_move1", this.split_move1);
            nbt.putString("split_move2", this.split_move2);
            nbt.putString("split_move3", this.split_move3);
            nbt.putString("split_move4", this.split_move4);
            nbt.putString("split_move5", this.split_move5);
            nbt.putString("split_move6", this.split_move6);
            nbt.putString("split_move7", this.split_move7);
            nbt.putString("split_move8", this.split_move8);
            nbt.putString("split_lastmove_npc", this.split_lastmove_npc);
            nbt.putString("split_move1_npc", this.split_move1_npc);
            nbt.putString("split_move2_npc", this.split_move2_npc);
            nbt.putString("split_move3_npc", this.split_move3_npc);
            nbt.putString("split_move4_npc", this.split_move4_npc);
            nbt.putString("split_move5_npc", this.split_move5_npc);
            nbt.putString("split_move6_npc", this.split_move6_npc);
            nbt.putString("split_move7_npc", this.split_move7_npc);
            nbt.putString("split_move8_npc", this.split_move8_npc);
            nbt.putDouble("split_round", this.split_round);
            nbt.putBoolean("split_npc_decided", this.split_npc_decided);
            nbt.putBoolean("split_player_move", this.split_player_move);
            nbt.putDouble("split_total", this.split_total);
            nbt.putDouble("split_toplayer", this.split_toplayer);
            nbt.putDouble("split_tonpc", this.split_tonpc);
            nbt.putBoolean("box_chance_logic", this.box_chance_logic);
            nbt.putBoolean("duper_cooldown_active", this.duper_cooldown_active);
            nbt.putDouble("duper_cooldown_clock_ticks", this.duper_cooldown_clock_ticks);
            nbt.putString("panel_viewing_ign", this.panel_viewing_ign);
            nbt.putDouble("panel_coins", this.panel_coins);
            nbt.putDouble("panel_max_coins", this.panel_max_coins);
            nbt.putDouble("panel_coins_in_bank", this.panel_coins_in_bank);
            nbt.putDouble("panel_max_coins_in_bank", this.panel_max_coins_in_bank);
            nbt.putDouble("panel_gems", this.panel_gems);
            nbt.putDouble("panel_max_gems", this.panel_max_gems);
            nbt.putDouble("panel_gems_in_bank", this.panel_gems_in_bank);
            nbt.putDouble("panel_max_gems_in_bank", this.panel_max_gems_in_bank);
            nbt.putDouble("panel_coin_chance", this.panel_coin_chance);
            nbt.putDouble("panel_gem_chance", this.panel_gem_chance);
            nbt.putDouble("panel_box_chance", this.panel_box_chance);
            nbt.putDouble("panel_coin_multiplier", this.panel_coin_multiplier);
            nbt.putBoolean("panel_slots_unlocked", this.panel_slots_unlocked);
            nbt.putDouble("panel_slot_spins", this.panel_slot_spins);
            nbt.putBoolean("panel_watermark_funny", this.panel_watermark_funny);
            nbt.putBoolean("panel_adblock_enabled", this.panel_adblock_enabled);
            nbt.putBoolean("panel_bank_unlocked", this.panel_bank_unlocked);
            nbt.putDouble("price_multiplier", this.price_multiplier);
            nbt.putDouble("upgrade_price_multiplier_cost", this.upgrade_price_multiplier_cost);
            nbt.putBoolean("price_mp_fixed", this.price_mp_fixed);
            nbt.putDouble("rebirths", this.rebirths);
            nbt.putDouble("rebirth_boost", this.rebirth_boost);
            nbt.putBoolean("rebirth_notify", this.rebirth_notify);
            nbt.putDouble("debt_to_world_bank", this.debt_to_world_bank);
            nbt.putDouble("debt_timer_ticks", this.debt_timer_ticks);
            nbt.putDouble("debt_timer_seconds", this.debt_timer_seconds);
            nbt.putDouble("bad_debt_timer", this.bad_debt_timer);
            nbt.putBoolean("failed_to_repay_debt", this.failed_to_repay_debt);
            nbt.putBoolean("is_loaning", this.is_loaning);
            nbt.putDouble("emptix_tokens", this.emptix_tokens);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.coins = nbt.getDouble("coins");
            this.gems = nbt.getDouble("gems");
            this.ValueOverlayShown = nbt.getBoolean("ValueOverlayShown");
            this.coin_chance = nbt.getDouble("coin_chance");
            this.box_chance = nbt.getDouble("box_chance");
            this.coin_multiplier = nbt.getDouble("coin_multiplier");
            this.combat_log_timer = nbt.getDouble("combat_log_timer");
            this.combat_logged = nbt.getBoolean("combat_logged");
            this.held_box_rarity = nbt.getDouble("held_box_rarity");
            this.opened_box_rarity = nbt.getDouble("opened_box_rarity");
            this.upgrade_coin_chance_cost = nbt.getDouble("upgrade_coin_chance_cost");
            this.upgrade_box_chance_cost = nbt.getDouble("upgrade_box_chance_cost");
            this.upgrade_coin_multiplayer_cost = nbt.getDouble("upgrade_coin_multiplayer_cost");
            this.gem_chance = nbt.getDouble("gem_chance");
            this.gem_chance_upgrade_cost = nbt.getDouble("gem_chance_upgrade_cost");
            this.gamble_slot_0 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("gamble_slot_0"));
            this.gamble_slot_1 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("gamble_slot_1"));
            this.gamble_slot_2 = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("gamble_slot_2"));
            this.slots_forgive = nbt.getDouble("slots_forgive");
            this.slots_rolling = nbt.getBoolean("slots_rolling");
            this.slots_unlocked = nbt.getBoolean("slots_unlocked");
            this.combat_log_time = nbt.getDouble("combat_log_time");
            this.upgrade_combat_log_time_cost = nbt.getDouble("upgrade_combat_log_time_cost");
            this.combat_log_time_seconds = nbt.getDouble("combat_log_time_seconds");
            this.debug_overlay_shown = nbt.getBoolean("debug_overlay_shown");
            this.lootbox_item = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("lootbox_item"));
            this.watermark_funny = nbt.getBoolean("watermark_funny");
            this.slot_thing = nbt.getDouble("slot_thing");
            this.dice_roll = nbt.getDouble("dice_roll");
            this.is_ad_active_right_now = nbt.getBoolean("is_ad_active_right_now");
            this.ad_time_until_skip = nbt.getDouble("ad_time_until_skip");
            this.adblock_enabled = nbt.getBoolean("adblock_enabled");
            this.can_skip_ad = nbt.getBoolean("can_skip_ad");
            this.time_until_ad_ticks = nbt.getDouble("time_until_ad_ticks");
            this.time_until_ad_seconds = nbt.getDouble("time_until_ad_seconds");
            this.time_until_ad_minutes = nbt.getDouble("time_until_ad_minutes");
            this.ad_time_until_skip_seconds = nbt.getDouble("ad_time_until_skip_seconds");
            this.tips_enabled = nbt.getBoolean("tips_enabled");
            this.captcha_active = nbt.getBoolean("captcha_active");
            this.human_number_1 = nbt.getDouble("human_number_1");
            this.human_number_2 = nbt.getDouble("human_number_2");
            this.human_number_3 = nbt.getDouble("human_number_3");
            this.GC_LEVEL = nbt.getDouble("GC_LEVEL");
            this.level_color = nbt.getString("level_color");
            this.gc_team_name = nbt.getString("gc_team_name");
            this.player_username = nbt.getString("player_username");
            this.gc_team_active = nbt.getBoolean("gc_team_active");
            this.gc_current_xp = nbt.getDouble("gc_current_xp");
            this.gc_total_xp = nbt.getDouble("gc_total_xp");
            this.max_coins = nbt.getDouble("max_coins");
            this.max_gems = nbt.getDouble("max_gems");
            this.bank_unlocked = nbt.getBoolean("bank_unlocked");
            this.coins_in_bank = nbt.getDouble("coins_in_bank");
            this.gems_in_bank = nbt.getDouble("gems_in_bank");
            this.max_coins_in_bank = nbt.getDouble("max_coins_in_bank");
            this.max_gems_in_bank = nbt.getDouble("max_gems_in_bank");
            this.bank_level = nbt.getDouble("bank_level");
            this.ignore_limits_dev = nbt.getBoolean("ignore_limits_dev");
            this.know_how_to_play = nbt.getBoolean("know_how_to_play");
            this.ignore_cooldowns_dev = nbt.getBoolean("ignore_cooldowns_dev");
            this.forgive_claimed = nbt.getBoolean("forgive_claimed");
            this.daily_collected = nbt.getBoolean("daily_collected");
            this.slot_spins = nbt.getDouble("slot_spins");
            this.daily_reminder_clock = nbt.getDouble("daily_reminder_clock");
            this.daily_reminder_action = nbt.getBoolean("daily_reminder_action");
            this.split_event_difficulty = nbt.getDouble("split_event_difficulty");
            this.split_lastmove = nbt.getString("split_lastmove");
            this.split_move1 = nbt.getString("split_move1");
            this.split_move2 = nbt.getString("split_move2");
            this.split_move3 = nbt.getString("split_move3");
            this.split_move4 = nbt.getString("split_move4");
            this.split_move5 = nbt.getString("split_move5");
            this.split_move6 = nbt.getString("split_move6");
            this.split_move7 = nbt.getString("split_move7");
            this.split_move8 = nbt.getString("split_move8");
            this.split_lastmove_npc = nbt.getString("split_lastmove_npc");
            this.split_move1_npc = nbt.getString("split_move1_npc");
            this.split_move2_npc = nbt.getString("split_move2_npc");
            this.split_move3_npc = nbt.getString("split_move3_npc");
            this.split_move4_npc = nbt.getString("split_move4_npc");
            this.split_move5_npc = nbt.getString("split_move5_npc");
            this.split_move6_npc = nbt.getString("split_move6_npc");
            this.split_move7_npc = nbt.getString("split_move7_npc");
            this.split_move8_npc = nbt.getString("split_move8_npc");
            this.split_round = nbt.getDouble("split_round");
            this.split_npc_decided = nbt.getBoolean("split_npc_decided");
            this.split_player_move = nbt.getBoolean("split_player_move");
            this.split_total = nbt.getDouble("split_total");
            this.split_toplayer = nbt.getDouble("split_toplayer");
            this.split_tonpc = nbt.getDouble("split_tonpc");
            this.box_chance_logic = nbt.getBoolean("box_chance_logic");
            this.duper_cooldown_active = nbt.getBoolean("duper_cooldown_active");
            this.duper_cooldown_clock_ticks = nbt.getDouble("duper_cooldown_clock_ticks");
            this.panel_viewing_ign = nbt.getString("panel_viewing_ign");
            this.panel_coins = nbt.getDouble("panel_coins");
            this.panel_max_coins = nbt.getDouble("panel_max_coins");
            this.panel_coins_in_bank = nbt.getDouble("panel_coins_in_bank");
            this.panel_max_coins_in_bank = nbt.getDouble("panel_max_coins_in_bank");
            this.panel_gems = nbt.getDouble("panel_gems");
            this.panel_max_gems = nbt.getDouble("panel_max_gems");
            this.panel_gems_in_bank = nbt.getDouble("panel_gems_in_bank");
            this.panel_max_gems_in_bank = nbt.getDouble("panel_max_gems_in_bank");
            this.panel_coin_chance = nbt.getDouble("panel_coin_chance");
            this.panel_gem_chance = nbt.getDouble("panel_gem_chance");
            this.panel_box_chance = nbt.getDouble("panel_box_chance");
            this.panel_coin_multiplier = nbt.getDouble("panel_coin_multiplier");
            this.panel_slots_unlocked = nbt.getBoolean("panel_slots_unlocked");
            this.panel_slot_spins = nbt.getDouble("panel_slot_spins");
            this.panel_watermark_funny = nbt.getBoolean("panel_watermark_funny");
            this.panel_adblock_enabled = nbt.getBoolean("panel_adblock_enabled");
            this.panel_bank_unlocked = nbt.getBoolean("panel_bank_unlocked");
            this.price_multiplier = nbt.getDouble("price_multiplier");
            this.upgrade_price_multiplier_cost = nbt.getDouble("upgrade_price_multiplier_cost");
            this.price_mp_fixed = nbt.getBoolean("price_mp_fixed");
            this.rebirths = nbt.getDouble("rebirths");
            this.rebirth_boost = nbt.getDouble("rebirth_boost");
            this.rebirth_notify = nbt.getBoolean("rebirth_notify");
            this.debt_to_world_bank = nbt.getDouble("debt_to_world_bank");
            this.debt_timer_ticks = nbt.getDouble("debt_timer_ticks");
            this.debt_timer_seconds = nbt.getDouble("debt_timer_seconds");
            this.bad_debt_timer = nbt.getDouble("bad_debt_timer");
            this.failed_to_repay_debt = nbt.getBoolean("failed_to_repay_debt");
            this.is_loaning = nbt.getBoolean("is_loaning");
            this.emptix_tokens = nbt.getDouble("emptix_tokens");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "generatorcraft_mapvars";
        public double gem_multiplier = 1.0;
        public boolean gem_boost_event_active = false;
        public boolean big_gem_bought = false;
        public String big_gem_owner = "\"\"";
        public String big_gem_date = "\"\"";
        public double time_until_tip = 0.0;
        public boolean hoarder_event_active = false;
        public ItemStack hoarder_item = ItemStack.EMPTY;
        public double GC_VERSION = 0.0;
        public double day_of_week = 0.0;
        public double duper_price = 15000.0;
        public boolean split_event_active = false;
        public double split_event_timer = 0.0;
        public boolean split_event_played = false;
        public boolean split_dev_enabled = false;
        public boolean adminpanel_enabled = false;
        public double event_timer = 0.0;
        public boolean event_active = false;
        public double active_event_id = 0.0;
        public String active_event_name = "\"\"";
        public boolean emptix_event_active = false;
        public double world_bank = 0.0;
        public double economy_boost = 0.0;
        public String economy_state = "\"\"";
        public boolean world_bank_default = false;
        public double real_price_multiplier = 0.0;
        public double real_output_multiplier = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.gem_multiplier = nbt.getDouble("gem_multiplier");
            this.gem_boost_event_active = nbt.getBoolean("gem_boost_event_active");
            this.big_gem_bought = nbt.getBoolean("big_gem_bought");
            this.big_gem_owner = nbt.getString("big_gem_owner");
            this.big_gem_date = nbt.getString("big_gem_date");
            this.time_until_tip = nbt.getDouble("time_until_tip");
            this.hoarder_event_active = nbt.getBoolean("hoarder_event_active");
            this.hoarder_item = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("hoarder_item"));
            this.GC_VERSION = nbt.getDouble("GC_VERSION");
            this.day_of_week = nbt.getDouble("day_of_week");
            this.duper_price = nbt.getDouble("duper_price");
            this.split_event_active = nbt.getBoolean("split_event_active");
            this.split_event_timer = nbt.getDouble("split_event_timer");
            this.split_event_played = nbt.getBoolean("split_event_played");
            this.split_dev_enabled = nbt.getBoolean("split_dev_enabled");
            this.adminpanel_enabled = nbt.getBoolean("adminpanel_enabled");
            this.event_timer = nbt.getDouble("event_timer");
            this.event_active = nbt.getBoolean("event_active");
            this.active_event_id = nbt.getDouble("active_event_id");
            this.active_event_name = nbt.getString("active_event_name");
            this.emptix_event_active = nbt.getBoolean("emptix_event_active");
            this.world_bank = nbt.getDouble("world_bank");
            this.economy_boost = nbt.getDouble("economy_boost");
            this.economy_state = nbt.getString("economy_state");
            this.world_bank_default = nbt.getBoolean("world_bank_default");
            this.real_price_multiplier = nbt.getDouble("real_price_multiplier");
            this.real_output_multiplier = nbt.getDouble("real_output_multiplier");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("gem_multiplier", this.gem_multiplier);
            nbt.putBoolean("gem_boost_event_active", this.gem_boost_event_active);
            nbt.putBoolean("big_gem_bought", this.big_gem_bought);
            nbt.putString("big_gem_owner", this.big_gem_owner);
            nbt.putString("big_gem_date", this.big_gem_date);
            nbt.putDouble("time_until_tip", this.time_until_tip);
            nbt.putBoolean("hoarder_event_active", this.hoarder_event_active);
            nbt.put("hoarder_item", this.hoarder_item.saveOptional(lookupProvider));
            nbt.putDouble("GC_VERSION", this.GC_VERSION);
            nbt.putDouble("day_of_week", this.day_of_week);
            nbt.putDouble("duper_price", this.duper_price);
            nbt.putBoolean("split_event_active", this.split_event_active);
            nbt.putDouble("split_event_timer", this.split_event_timer);
            nbt.putBoolean("split_event_played", this.split_event_played);
            nbt.putBoolean("split_dev_enabled", this.split_dev_enabled);
            nbt.putBoolean("adminpanel_enabled", this.adminpanel_enabled);
            nbt.putDouble("event_timer", this.event_timer);
            nbt.putBoolean("event_active", this.event_active);
            nbt.putDouble("active_event_id", this.active_event_id);
            nbt.putString("active_event_name", this.active_event_name);
            nbt.putBoolean("emptix_event_active", this.emptix_event_active);
            nbt.putDouble("world_bank", this.world_bank);
            nbt.putDouble("economy_boost", this.economy_boost);
            nbt.putString("economy_state", this.economy_state);
            nbt.putBoolean("world_bank_default", this.world_bank_default);
            nbt.putDouble("real_price_multiplier", this.real_price_multiplier);
            nbt.putDouble("real_output_multiplier", this.real_output_multiplier);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "generatorcraft_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.coins = original.coins;
            clone.gems = original.gems;
            clone.ValueOverlayShown = original.ValueOverlayShown;
            clone.coin_chance = original.coin_chance;
            clone.box_chance = original.box_chance;
            clone.coin_multiplier = original.coin_multiplier;
            clone.held_box_rarity = original.held_box_rarity;
            clone.opened_box_rarity = original.opened_box_rarity;
            clone.upgrade_coin_chance_cost = original.upgrade_coin_chance_cost;
            clone.upgrade_box_chance_cost = original.upgrade_box_chance_cost;
            clone.upgrade_coin_multiplayer_cost = original.upgrade_coin_multiplayer_cost;
            clone.gem_chance = original.gem_chance;
            clone.gem_chance_upgrade_cost = original.gem_chance_upgrade_cost;
            clone.gamble_slot_0 = original.gamble_slot_0;
            clone.gamble_slot_1 = original.gamble_slot_1;
            clone.gamble_slot_2 = original.gamble_slot_2;
            clone.slots_forgive = original.slots_forgive;
            clone.slots_rolling = original.slots_rolling;
            clone.slots_unlocked = original.slots_unlocked;
            clone.combat_log_time = original.combat_log_time;
            clone.upgrade_combat_log_time_cost = original.upgrade_combat_log_time_cost;
            clone.combat_log_time_seconds = original.combat_log_time_seconds;
            clone.debug_overlay_shown = original.debug_overlay_shown;
            clone.lootbox_item = original.lootbox_item;
            clone.watermark_funny = original.watermark_funny;
            clone.slot_thing = original.slot_thing;
            clone.dice_roll = original.dice_roll;
            clone.is_ad_active_right_now = original.is_ad_active_right_now;
            clone.ad_time_until_skip = original.ad_time_until_skip;
            clone.adblock_enabled = original.adblock_enabled;
            clone.can_skip_ad = original.can_skip_ad;
            clone.time_until_ad_ticks = original.time_until_ad_ticks;
            clone.time_until_ad_seconds = original.time_until_ad_seconds;
            clone.time_until_ad_minutes = original.time_until_ad_minutes;
            clone.ad_time_until_skip_seconds = original.ad_time_until_skip_seconds;
            clone.tips_enabled = original.tips_enabled;
            clone.captcha_active = original.captcha_active;
            clone.human_number_1 = original.human_number_1;
            clone.human_number_2 = original.human_number_2;
            clone.human_number_3 = original.human_number_3;
            clone.GC_LEVEL = original.GC_LEVEL;
            clone.level_color = original.level_color;
            clone.gc_team_name = original.gc_team_name;
            clone.player_username = original.player_username;
            clone.gc_team_active = original.gc_team_active;
            clone.gc_current_xp = original.gc_current_xp;
            clone.gc_total_xp = original.gc_total_xp;
            clone.max_coins = original.max_coins;
            clone.max_gems = original.max_gems;
            clone.bank_unlocked = original.bank_unlocked;
            clone.coins_in_bank = original.coins_in_bank;
            clone.gems_in_bank = original.gems_in_bank;
            clone.max_coins_in_bank = original.max_coins_in_bank;
            clone.max_gems_in_bank = original.max_gems_in_bank;
            clone.bank_level = original.bank_level;
            clone.ignore_limits_dev = original.ignore_limits_dev;
            clone.know_how_to_play = original.know_how_to_play;
            clone.ignore_cooldowns_dev = original.ignore_cooldowns_dev;
            clone.forgive_claimed = original.forgive_claimed;
            clone.daily_collected = original.daily_collected;
            clone.slot_spins = original.slot_spins;
            clone.daily_reminder_clock = original.daily_reminder_clock;
            clone.daily_reminder_action = original.daily_reminder_action;
            clone.split_event_difficulty = original.split_event_difficulty;
            clone.split_lastmove = original.split_lastmove;
            clone.split_move1 = original.split_move1;
            clone.split_move2 = original.split_move2;
            clone.split_move3 = original.split_move3;
            clone.split_move4 = original.split_move4;
            clone.split_move5 = original.split_move5;
            clone.split_move6 = original.split_move6;
            clone.split_move7 = original.split_move7;
            clone.split_move8 = original.split_move8;
            clone.split_lastmove_npc = original.split_lastmove_npc;
            clone.split_move1_npc = original.split_move1_npc;
            clone.split_move2_npc = original.split_move2_npc;
            clone.split_move3_npc = original.split_move3_npc;
            clone.split_move4_npc = original.split_move4_npc;
            clone.split_move5_npc = original.split_move5_npc;
            clone.split_move6_npc = original.split_move6_npc;
            clone.split_move7_npc = original.split_move7_npc;
            clone.split_move8_npc = original.split_move8_npc;
            clone.split_round = original.split_round;
            clone.split_npc_decided = original.split_npc_decided;
            clone.split_player_move = original.split_player_move;
            clone.split_total = original.split_total;
            clone.split_toplayer = original.split_toplayer;
            clone.split_tonpc = original.split_tonpc;
            clone.box_chance_logic = original.box_chance_logic;
            clone.duper_cooldown_active = original.duper_cooldown_active;
            clone.duper_cooldown_clock_ticks = original.duper_cooldown_clock_ticks;
            clone.panel_viewing_ign = original.panel_viewing_ign;
            clone.panel_coins = original.panel_coins;
            clone.panel_max_coins = original.panel_max_coins;
            clone.panel_coins_in_bank = original.panel_coins_in_bank;
            clone.panel_max_coins_in_bank = original.panel_max_coins_in_bank;
            clone.panel_gems = original.panel_gems;
            clone.panel_max_gems = original.panel_max_gems;
            clone.panel_gems_in_bank = original.panel_gems_in_bank;
            clone.panel_max_gems_in_bank = original.panel_max_gems_in_bank;
            clone.panel_coin_chance = original.panel_coin_chance;
            clone.panel_gem_chance = original.panel_gem_chance;
            clone.panel_box_chance = original.panel_box_chance;
            clone.panel_coin_multiplier = original.panel_coin_multiplier;
            clone.panel_slots_unlocked = original.panel_slots_unlocked;
            clone.panel_slot_spins = original.panel_slot_spins;
            clone.panel_watermark_funny = original.panel_watermark_funny;
            clone.panel_adblock_enabled = original.panel_adblock_enabled;
            clone.panel_bank_unlocked = original.panel_bank_unlocked;
            clone.price_multiplier = original.price_multiplier;
            clone.upgrade_price_multiplier_cost = original.upgrade_price_multiplier_cost;
            clone.price_mp_fixed = original.price_mp_fixed;
            clone.rebirths = original.rebirths;
            clone.rebirth_boost = original.rebirth_boost;
            clone.rebirth_notify = original.rebirth_notify;
            clone.debt_to_world_bank = original.debt_to_world_bank;
            clone.debt_timer_ticks = original.debt_timer_ticks;
            clone.debt_timer_seconds = original.debt_timer_seconds;
            clone.bad_debt_timer = original.bad_debt_timer;
            clone.failed_to_repay_debt = original.failed_to_repay_debt;
            clone.is_loaning = original.is_loaning;
            clone.emptix_tokens = original.emptix_tokens;
            if (!event.isWasDeath()) {
                clone.combat_log_timer = original.combat_log_timer;
                clone.combat_logged = original.combat_logged;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

