/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.HashMap;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.mcreator.generatorcraft.procedures.AdblockShopButtonProcedure;
import net.mcreator.generatorcraft.procedures.BANKINGBUTTONProcedure;
import net.mcreator.generatorcraft.procedures.BoxToggleButtonProcedure;
import net.mcreator.generatorcraft.procedures.GEMSHOPBUTTONProcedure;
import net.mcreator.generatorcraft.procedures.RebirthGUIOpenProcedure;
import net.mcreator.generatorcraft.procedures.SlotGambleGUIButtonProcedure;
import net.mcreator.generatorcraft.procedures.UpgradeBoxChanceProcedure;
import net.mcreator.generatorcraft.procedures.UpgradeCoinChanceProcedure;
import net.mcreator.generatorcraft.procedures.UpgradeCoinMultiplayerProcedure;
import net.mcreator.generatorcraft.procedures.UpgradeCombatTimeButtonProcedure;
import net.mcreator.generatorcraft.procedures.UpgradeGemChanceProcedure;
import net.mcreator.generatorcraft.procedures.UpgradePriceMultiplierButtonProcedure;
import net.mcreator.generatorcraft.procedures.WatermarkRemoveShopButtonProcedure;
import net.mcreator.generatorcraft.world.inventory.GeneratorcraftStoreMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record GeneratorcraftStoreButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GeneratorcraftStoreButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)"generatorcraft_store_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GeneratorcraftStoreButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new GeneratorcraftStoreButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GeneratorcraftStoreButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(GeneratorcraftStoreButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                GeneratorcraftStoreButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = GeneratorcraftStoreMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            UpgradeCoinChanceProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            UpgradeBoxChanceProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            UpgradeCoinMultiplayerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            UpgradeGemChanceProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GEMSHOPBUTTONProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            SlotGambleGUIButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            UpgradeCombatTimeButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            WatermarkRemoveShopButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            AdblockShopButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            BANKINGBUTTONProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            BoxToggleButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            UpgradePriceMultiplierButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            RebirthGUIOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(TYPE, STREAM_CODEC, GeneratorcraftStoreButtonMessage::handleData);
    }
}

