/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedepths.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelCaracal<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_depths", "model_caracal"), "main");
    public final ModelPart body;
    public final ModelPart belly;
    public final ModelPart head;
    public final ModelPart tail1;
    public final ModelPart tail2;
    public final ModelPart backLegL;
    public final ModelPart backLegR;
    public final ModelPart frontLegL;
    public final ModelPart frontLegR;

    public ModelCaracal(ModelPart root) {
        this.body = root.getChild("body");
        this.belly = this.body.getChild("belly");
        this.head = this.body.getChild("head");
        this.tail1 = this.body.getChild("tail1");
        this.tail2 = this.tail1.getChild("tail2");
        this.backLegL = this.body.getChild("backLegL");
        this.backLegR = this.body.getChild("backLegR");
        this.frontLegL = this.body.getChild("frontLegL");
        this.frontLegR = this.body.getChild("frontLegR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)1.0f));
        PartDefinition belly = body.addOrReplaceChild("belly", CubeListBuilder.create().texOffs(20, 0).addBox(-2.0f, -8.0f, -3.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-1.5f, -0.0156f, -4.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-2.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 10).addBox(1.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -5.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -5.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(1.0f, -5.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(2.0f, -5.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-10.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(43, 21).addBox(-1.0f, -3.0f, -2.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.0f, (float)1.0f, (float)0.0f, (float)-1.5272f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(43, 21).addBox(-1.0f, -3.0f, -2.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)2.0f, (float)1.0f, (float)0.0f, (float)-1.5272f, (float)0.0f));
        PartDefinition tail1 = body.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)7.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(4, 15).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition backLegL = body.addOrReplaceChild("backLegL", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.1f, (float)1.0f, (float)6.0f));
        PartDefinition backLegR = body.addOrReplaceChild("backLegR", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.1f, (float)1.0f, (float)6.0f));
        PartDefinition frontLegL = body.addOrReplaceChild("frontLegL", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -0.2f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.2f, (float)-3.0f, (float)-5.0f));
        PartDefinition frontLegR = body.addOrReplaceChild("frontLegR", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -0.2f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.2f, (float)-3.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.backLegL.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.frontLegR.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.backLegR.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.frontLegL.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

