/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mejik.init;

import net.mcreator.mejik.potion.EndBurnMobEffect;
import net.mcreator.mejik.potion.FireballerMobEffect;
import net.mcreator.mejik.potion.ManahealingMobEffect;
import net.mcreator.mejik.procedures.ManahealingEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class MejikModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"mejik");
    public static final DeferredHolder<MobEffect, MobEffect> MANAHEALING = REGISTRY.register("manahealing", () -> new ManahealingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FIREBALLER = REGISTRY.register("fireballer", () -> new FireballerMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> END_CURSE = REGISTRY.register("end_curse", () -> new EndBurnMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MejikModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MejikModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(MANAHEALING)) {
            ManahealingEffectExpiresProcedure.execute(entity);
        }
    }
}

