/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CastIronDropHatchBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final EnumProperty<Tilt> TILT = BlockStateProperties.TILT;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), p_152305_ -> {
        p_152305_.defaultReturnValue(-1);
        p_152305_.put((Object)Tilt.UNSTABLE, 20);
        p_152305_.put((Object)Tilt.PARTIAL, 20);
        p_152305_.put((Object)Tilt.FULL, 200);
    });

    public CastIronDropHatchBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.METAL).strength(6.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH)).setValue(TILT, (Comparable)Tilt.NONE));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.TRAPDOOR;
    }

    protected FluidState getFluidState(BlockState p_152312_) {
        return (Boolean)p_152312_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_152312_);
    }

    protected boolean canSurvive(BlockState p_152289_, LevelReader p_152290_, BlockPos p_152291_) {
        return true;
    }

    protected BlockState updateShape(BlockState p_152293_, LevelReader p_374459_, ScheduledTickAccess p_374181_, BlockPos p_152297_, Direction p_152294_, BlockPos p_152298_, BlockState p_152295_, RandomSource p_374504_) {
        if (p_152294_ == Direction.DOWN && !p_152293_.canSurvive(p_374459_, p_152297_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)p_152293_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374181_.scheduleTick(p_152297_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374459_));
        }
        return super.updateShape(p_152293_, p_374459_, p_374181_, p_152297_, p_152294_, p_152298_, p_152295_, p_374504_);
    }

    @Nullable
    public boolean isValidBonemealTarget(LevelReader p_255698_, BlockPos p_256302_, BlockState p_255648_) {
        return false;
    }

    @Nullable
    public boolean isBonemealSuccess(Level p_220788_, RandomSource p_220789_, BlockPos p_220790_, BlockState p_220791_) {
        return false;
    }

    @Nullable
    public void performBonemeal(ServerLevel p_220783_, RandomSource p_220784_, BlockPos p_220785_, BlockState p_220786_) {
    }

    protected void entityInside(BlockState p_152266_, Level p_152267_, BlockPos p_152268_, Entity p_152269_) {
        if (!p_152267_.isClientSide && p_152266_.getValue(TILT) == Tilt.NONE && CastIronDropHatchBlock.canEntityTilt(p_152268_, p_152269_) && !p_152267_.hasNeighborSignal(p_152268_)) {
            this.setTiltAndScheduleTick(p_152266_, p_152267_, p_152268_, Tilt.UNSTABLE, null);
        }
    }

    protected void tick(BlockState p_220798_, ServerLevel p_220799_, BlockPos p_220800_, RandomSource p_220801_) {
        if (p_220799_.hasNeighborSignal(p_220800_)) {
            CastIronDropHatchBlock.resetTilt(p_220798_, (Level)p_220799_, p_220800_);
        } else {
            Tilt tilt = (Tilt)p_220798_.getValue(TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(p_220798_, (Level)p_220799_, p_220800_, Tilt.PARTIAL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(p_220798_, (Level)p_220799_, p_220800_, Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN);
            } else if (tilt == Tilt.FULL) {
                CastIronDropHatchBlock.resetTilt(p_220798_, (Level)p_220799_, p_220800_);
            }
        }
    }

    protected void neighborChanged(BlockState p_152271_, Level p_152272_, BlockPos p_152273_, Block p_152274_, @Nullable Orientation p_364767_, boolean p_152276_) {
        if (p_152272_.hasNeighborSignal(p_152273_)) {
            CastIronDropHatchBlock.resetTilt(p_152271_, p_152272_, p_152273_);
        }
    }

    private static void playTiltSound(Level p_152233_, BlockPos p_152234_, SoundEvent p_152235_) {
        float f = Mth.randomBetween((RandomSource)p_152233_.random, (float)0.8f, (float)1.2f);
        p_152233_.playSound(null, p_152234_, p_152235_, SoundSource.BLOCKS, 1.0f, f);
    }

    private static boolean canEntityTilt(BlockPos p_152302_, Entity p_152303_) {
        return p_152303_.onGround() && p_152303_.position().y > (double)((float)p_152302_.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState p_152283_, Level p_152284_, BlockPos p_152285_, Tilt p_152286_, @Nullable SoundEvent p_152287_) {
        int i;
        CastIronDropHatchBlock.setTilt(p_152283_, p_152284_, p_152285_, p_152286_);
        if (p_152287_ != null) {
            CastIronDropHatchBlock.playTiltSound(p_152284_, p_152285_, p_152287_);
        }
        if ((i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)p_152286_)) != -1) {
            p_152284_.scheduleTick(p_152285_, (Block)this, i);
        }
    }

    private static void resetTilt(BlockState p_152314_, Level p_152315_, BlockPos p_152316_) {
        CastIronDropHatchBlock.setTilt(p_152314_, p_152315_, p_152316_, Tilt.NONE);
        if (p_152314_.getValue(TILT) != Tilt.NONE) {
            CastIronDropHatchBlock.playTiltSound(p_152315_, p_152316_, SoundEvents.BIG_DRIPLEAF_TILT_UP);
        }
    }

    private static void setTilt(BlockState p_152278_, Level p_152279_, BlockPos p_152280_, Tilt p_152281_) {
        Tilt tilt = (Tilt)p_152278_.getValue(TILT);
        p_152279_.setBlock(p_152280_, (BlockState)p_152278_.setValue(TILT, (Comparable)p_152281_), 2);
        if (p_152281_.causesVibration() && p_152281_ != tilt) {
            p_152279_.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, p_152280_);
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Tilt)state.getValue(TILT)) {
            default -> CastIronDropHatchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
            case Tilt.UNSTABLE -> CastIronDropHatchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
            case Tilt.PARTIAL -> CastIronDropHatchBlock.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
            case Tilt.FULL -> CastIronDropHatchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Tilt)state.getValue(TILT)) {
            default -> CastIronDropHatchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
            case Tilt.UNSTABLE -> CastIronDropHatchBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
            case Tilt.PARTIAL -> CastIronDropHatchBlock.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
            case Tilt.FULL -> CastIronDropHatchBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_152221_) {
        BlockState blockstate = p_152221_.getLevel().getBlockState(p_152221_.getClickedPos().below());
        FluidState fluidstate = p_152221_.getLevel().getFluidState(p_152221_.getClickedPos());
        boolean flag = blockstate.is(Blocks.BIG_DRIPLEAF) || blockstate.is(Blocks.BIG_DRIPLEAF_STEM);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.isSourceOfType((Fluid)Fluids.WATER)))).setValue(FACING, (Comparable)(flag ? (Direction)blockstate.getValue(FACING) : p_152221_.getHorizontalDirection().getOpposite()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_152300_) {
        p_152300_.add(new Property[]{WATERLOGGED, FACING, TILT});
    }

    protected BlockState rotate(BlockState p_54125_, Rotation p_54126_) {
        return (BlockState)p_54125_.setValue(FACING, (Comparable)p_54126_.rotate((Direction)p_54125_.getValue(FACING)));
    }

    protected BlockState mirror(BlockState p_54122_, Mirror p_54123_) {
        return p_54122_.rotate(p_54123_.getRotation((Direction)p_54122_.getValue(FACING)));
    }
}

