/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import net.mcreator.ddfabfmr.procedures.ChampignonsBonemealProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class ChampignonsBlock
extends FlowerBlock
implements BonemealableBlock {
    public ChampignonsBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, properties.mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().pushReaction(PushReaction.DESTROY).randomTicks());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ChampignonsBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    }

    protected boolean mayPlaceOn(BlockState p_51042_, BlockGetter p_51043_, BlockPos p_51044_) {
        return p_51042_.is(BlockTags.DIRT) || p_51042_.getBlock() instanceof FarmBlock;
    }

    protected boolean canSurvive(BlockState p_51028_, LevelReader p_51029_, BlockPos p_51030_) {
        BlockPos blockpos = p_51030_.below();
        BlockState belowBlockState = p_51029_.getBlockState(blockpos);
        TriState soilDecision = belowBlockState.canSustainPlant((BlockGetter)p_51029_, blockpos, Direction.UP, p_51028_);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return this.mayPlaceOn(belowBlockState, (BlockGetter)p_51029_, blockpos);
    }

    protected void randomTick(BlockState p_221784_, ServerLevel p_221785_, BlockPos p_221786_, RandomSource p_221787_) {
        if (p_221787_.nextInt(15) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)p_221786_.offset(-4, -1, -4), (BlockPos)p_221786_.offset(4, 1, 4))) {
                if (!p_221785_.getBlockState(blockpos).is((Block)this) || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = p_221786_.offset(p_221787_.nextInt(3) - 1, p_221787_.nextInt(2) - p_221787_.nextInt(2), p_221787_.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (p_221785_.isEmptyBlock(blockpos1) && p_221784_.canSurvive((LevelReader)p_221785_, blockpos1)) {
                    p_221786_ = blockpos1;
                }
                blockpos1 = p_221786_.offset(p_221787_.nextInt(3) - 1, p_221787_.nextInt(2) - p_221787_.nextInt(2), p_221787_.nextInt(3) - 1);
            }
            if (p_221785_.isEmptyBlock(blockpos1) && p_221784_.canSurvive((LevelReader)p_221785_, blockpos1)) {
                p_221785_.setBlock(blockpos1, p_221784_, 2);
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader p_255904_, BlockPos p_54871_, BlockState p_54872_) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_221779_, RandomSource p_221780_, BlockPos p_221781_, BlockState p_221782_) {
        return (double)p_221780_.nextFloat() < 0.4;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState blockstate) {
        ChampignonsBonemealProcedureProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

