/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;

public class CinderSlabBlock
extends SlabBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public CinderSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.STONE).sound(SoundType.DEEPSLATE_BRICKS).strength(3.0f, 6.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.BASEDRUM));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Z));
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.setValue(AXIS, (Comparable)(state.getValue(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_56361_) {
        BlockPos blockpos = p_56361_.getClickedPos();
        BlockState blockstate = p_56361_.getLevel().getBlockState(blockpos);
        if (blockstate.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)p_56361_.getHorizontalDirection().getAxis());
        }
        FluidState fluidstate = p_56361_.getLevel().getFluidState(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue(AXIS, (Comparable)p_56361_.getHorizontalDirection().getAxis());
        Direction direction = p_56361_.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && p_56361_.getClickLocation().y - (double)blockpos.getY() > 0.5) ? blockstate1 : (BlockState)blockstate1.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }
}

