/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class CoconutBlock
extends FallingBlock
implements BonemealableBlock {
    public static final MapCodec<CoconutBlock> CODEC = CoconutBlock.simpleCodec(CoconutBlock::new);
    public static final BooleanProperty CRACKED = BlockStateProperties.CRACKED;

    public MapCodec<CoconutBlock> codec() {
        return CODEC;
    }

    public CoconutBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_BROWN).sound(SoundType.WOOD).strength(1.0f).instrument(NoteBlockInstrument.BASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 1;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CRACKED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false));
    }

    protected void tick(BlockState p_221124_, ServerLevel p_221125_, BlockPos p_221126_, RandomSource p_221127_) {
        if (CoconutBlock.isFree((BlockState)p_221125_.getBlockState(p_221126_.below())) && p_221126_.getY() >= p_221125_.getMinY() && !p_221125_.getBlockState(p_221126_.above()).is(BlockTags.LEAVES)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)p_221125_, (BlockPos)p_221126_, (BlockState)p_221124_);
            this.falling(fallingblockentity);
        }
    }

    protected void falling(FallingBlockEntity p_48779_) {
        p_48779_.setHurtsEntities(1.0f, 5);
    }

    public void onLand(Level p_48793_, BlockPos p_48794_, BlockState p_48795_, BlockState p_48796_, FallingBlockEntity p_48797_) {
        p_48793_.setBlock(p_48794_, (BlockState)((Block)DdfabfmrModBlocks.COCONUT.get()).defaultBlockState().setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 3);
        p_48793_.destroyBlock(p_48794_, true, null);
        if (!p_48793_.isClientSide()) {
            p_48793_.playSound(null, p_48794_, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            p_48793_.playLocalSound((double)p_48794_.getX(), (double)p_48794_.getY(), (double)p_48794_.getZ(), SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance);
        if (!level.isClientSide && !entity.isSteppingCarefully() && fallDistance > 3.0f && CoconutBlock.hasEnergyToBreak(entity)) {
            level.setBlock(pos, (BlockState)((Block)DdfabfmrModBlocks.COCONUT.get()).defaultBlockState().setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 3);
            level.destroyBlock(pos, true, entity);
            level.playSound(null, pos, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container tile = (Container)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)tile);
            }
        }
    }

    private static boolean hasEnergyToBreak(Entity entity) {
        return entity.getBoundingBox().getSize() > 0.5 && (entity instanceof LivingEntity || entity instanceof FallingBlockEntity);
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState blockstate) {
        return worldIn.isEmptyBlock(pos.above());
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState blockstate) {
        world.setBlock(pos.above(), ((Block)DdfabfmrModBlocks.PALM_SAPLING.get()).defaultBlockState(), 3);
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

