/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;

public class CottonBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<CottonBlock> CODEC = CottonBlock.simpleCodec(CottonBlock::new);
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public CottonBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).sound(SoundType.CROP).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.NONE).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData, Player entity) {
        return new ItemStack((ItemLike)DdfabfmrModBlocks.COTTON.get());
    }

    public MapCodec<? extends CottonBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState p_52297_, BlockGetter p_52298_, BlockPos p_52299_, CollisionContext p_52300_) {
        return SHAPE_BY_AGE[this.getAge(p_52297_)];
    }

    protected boolean mayPlaceOn(BlockState p_52302_, BlockGetter p_52303_, BlockPos p_52304_) {
        return p_52302_.getBlock() instanceof FarmBlock;
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 4;
    }

    public int getAge(BlockState p_52306_) {
        return (Integer)p_52306_.getValue((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int p_52290_) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(p_52290_));
    }

    public final boolean isMaxAge(BlockState p_52308_) {
        return this.getAge(p_52308_) >= this.getMaxAge();
    }

    protected boolean isRandomlyTicking(BlockState p_52288_) {
        return !this.isMaxAge(p_52288_);
    }

    protected void randomTick(BlockState p_221050_, ServerLevel p_221051_, BlockPos p_221052_, RandomSource p_221053_) {
        float f;
        int i;
        if (!p_221051_.isAreaLoaded(p_221052_, 1)) {
            return;
        }
        if (p_221051_.getRawBrightness(p_221052_, 0) >= 9 && (i = this.getAge(p_221050_)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)p_221051_, (BlockPos)p_221052_, (BlockState)p_221050_, (p_221053_.nextInt((int)(25.0f / (f = CottonBlock.getGrowthSpeed(p_221050_, (BlockGetter)p_221051_, p_221052_))) + 1) == 0 ? 1 : 0) != 0)) {
            p_221051_.setBlock(p_221052_, this.getStateForAge(i + 1), 2);
            CommonHooks.fireCropGrowPost((Level)p_221051_, (BlockPos)p_221052_, (BlockState)p_221050_);
        }
    }

    public void growCrops(Level p_52264_, BlockPos p_52265_, BlockState p_52266_) {
        int j;
        int i = this.getAge(p_52266_) + this.getBonemealAgeIncrease(p_52264_);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        p_52264_.setBlock(p_52265_, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level p_52262_) {
        return Mth.nextInt((RandomSource)p_52262_.random, (int)1, (int)2);
    }

    protected static float getGrowthSpeed(BlockState blockState, BlockGetter p_52274_, BlockPos p_52275_) {
        boolean flag1;
        Block p_52273_ = blockState.getBlock();
        float f = 1.0f;
        BlockPos blockpos = p_52275_.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = p_52274_.getBlockState(blockpos.offset(i, 0, j));
                TriState soilDecision = blockstate.canSustainPlant(p_52274_, blockpos.offset(i, 0, j), Direction.UP, blockState);
                if (soilDecision.isDefault() ? blockstate.getBlock() instanceof FarmBlock : soilDecision.isTrue()) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(p_52274_, p_52275_.offset(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = p_52275_.north();
        BlockPos blockpos2 = p_52275_.south();
        BlockPos blockpos3 = p_52275_.west();
        BlockPos blockpos4 = p_52275_.east();
        boolean flag = p_52274_.getBlockState(blockpos3).is(p_52273_) || p_52274_.getBlockState(blockpos4).is(p_52273_);
        boolean bl = flag1 = p_52274_.getBlockState(blockpos1).is(p_52273_) || p_52274_.getBlockState(blockpos2).is(p_52273_);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = p_52274_.getBlockState(blockpos3.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.south()).is(p_52273_) || p_52274_.getBlockState(blockpos3.south()).is(p_52273_);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    protected boolean canSurvive(BlockState p_52282_, LevelReader p_52283_, BlockPos p_52284_) {
        TriState soilDecision = p_52283_.getBlockState(p_52284_.below()).canSustainPlant((BlockGetter)p_52283_, p_52284_.below(), Direction.UP, p_52282_);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return CottonBlock.hasSufficientLight(p_52283_, p_52284_) && super.canSurvive(p_52282_, p_52283_, p_52284_);
    }

    public static boolean hasSufficientLight(LevelReader p_294828_, BlockPos p_295989_) {
        return p_294828_.getRawBrightness(p_295989_, 0) >= 8;
    }

    protected void entityInside(BlockState p_52277_, Level p_52278_, BlockPos p_52279_, Entity p_52280_) {
        if (p_52278_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_52278_;
            if (p_52280_ instanceof Ravager && EventHooks.canEntityGrief((ServerLevel)serverlevel, (Entity)p_52280_)) {
                serverlevel.destroyBlock(p_52279_, true, p_52280_);
            }
        }
        super.entityInside(p_52277_, p_52278_, p_52279_, p_52280_);
    }

    public boolean isValidBonemealTarget(LevelReader p_255715_, BlockPos p_52259_, BlockState p_52260_) {
        return !this.isMaxAge(p_52260_);
    }

    public boolean isBonemealSuccess(Level p_221045_, RandomSource p_221046_, BlockPos p_221047_, BlockState p_221048_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_221040_, RandomSource p_221041_, BlockPos p_221042_, BlockState p_221043_) {
        this.growCrops((Level)p_221040_, p_221042_, p_221043_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52286_) {
        p_52286_.add(new Property[]{AGE});
    }
}

