/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;

public class CourgetteSeedsBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)};

    public CourgetteSeedsBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, properties.mapColor(MapColor.PLANT).randomTicks().sound(SoundType.HARD_CROP).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.NONE).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState p_57047_, BlockGetter p_57048_, BlockPos p_57049_, CollisionContext p_57050_) {
        return SHAPE_BY_AGE[(Integer)p_57047_.getValue((Property)AGE)];
    }

    protected boolean mayPlaceOn(BlockState p_57053_, BlockGetter p_57054_, BlockPos p_57055_) {
        return p_57053_.getBlock() instanceof FarmBlock;
    }

    protected void randomTick(BlockState p_222538_, ServerLevel p_222539_, BlockPos p_222540_, RandomSource p_222541_) {
        float f;
        if (!p_222539_.isAreaLoaded(p_222540_, 1)) {
            return;
        }
        if (p_222539_.getRawBrightness(p_222540_, 0) >= 9 && CommonHooks.canCropGrow((Level)p_222539_, (BlockPos)p_222540_, (BlockState)p_222538_, (p_222541_.nextInt((int)(25.0f / (f = CourgetteSeedsBlock.getGrowthSpeed(p_222538_, (BlockGetter)p_222539_, p_222540_))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)p_222538_.getValue((Property)AGE);
            if (i < 7) {
                p_222539_.setBlock(p_222540_, (BlockState)p_222538_.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(p_222541_);
                BlockPos blockpos = p_222540_.relative(direction);
                BlockState blockstate = p_222539_.getBlockState(blockpos.below());
                if (p_222539_.isEmptyBlock(blockpos) && (blockstate.getBlock() instanceof FarmBlock || blockstate.is(BlockTags.DIRT))) {
                    p_222539_.setBlockAndUpdate(blockpos, ((Block)DdfabfmrModBlocks.COURGETTE.get()).defaultBlockState());
                    p_222539_.setBlockAndUpdate(p_222540_, (BlockState)((Block)DdfabfmrModBlocks.COURGETTE_SEEDS_ATTACHED.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
                }
            }
            CommonHooks.fireCropGrowPost((Level)p_222539_, (BlockPos)p_222540_, (BlockState)p_222538_);
        }
    }

    public boolean isValidBonemealTarget(LevelReader p_255699_, BlockPos p_57031_, BlockState p_57032_) {
        return (Integer)p_57032_.getValue((Property)AGE) != 7;
    }

    public boolean isBonemealSuccess(Level p_222533_, RandomSource p_222534_, BlockPos p_222535_, BlockState p_222536_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_222528_, RandomSource p_222529_, BlockPos p_222530_, BlockState p_222531_) {
        int i = Math.min(7, (Integer)p_222531_.getValue((Property)AGE) + Mth.nextInt((RandomSource)p_222528_.random, (int)2, (int)5));
        BlockState blockstate = (BlockState)p_222531_.setValue((Property)AGE, (Comparable)Integer.valueOf(i));
        p_222528_.setBlock(p_222530_, blockstate, 2);
        if (i == 7) {
            blockstate.randomTick(p_222528_, p_222530_, p_222528_.random);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57040_) {
        p_57040_.add(new Property[]{AGE});
    }

    protected static float getGrowthSpeed(BlockState blockState, BlockGetter p_52274_, BlockPos p_52275_) {
        boolean flag1;
        Block p_52273_ = blockState.getBlock();
        float f = 1.0f;
        BlockPos blockpos = p_52275_.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = p_52274_.getBlockState(blockpos.offset(i, 0, j));
                TriState soilDecision = blockstate.canSustainPlant(p_52274_, blockpos.offset(i, 0, j), Direction.UP, blockState);
                if (soilDecision.isDefault() ? blockstate.getBlock() instanceof FarmBlock : soilDecision.isTrue()) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(p_52274_, p_52275_.offset(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = p_52275_.north();
        BlockPos blockpos2 = p_52275_.south();
        BlockPos blockpos3 = p_52275_.west();
        BlockPos blockpos4 = p_52275_.east();
        boolean flag = p_52274_.getBlockState(blockpos3).is(p_52273_) || p_52274_.getBlockState(blockpos4).is(p_52273_);
        boolean bl = flag1 = p_52274_.getBlockState(blockpos1).is(p_52273_) || p_52274_.getBlockState(blockpos2).is(p_52273_);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = p_52274_.getBlockState(blockpos3.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.north()).is(p_52273_) || p_52274_.getBlockState(blockpos4.south()).is(p_52273_) || p_52274_.getBlockState(blockpos3.south()).is(p_52273_);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }
}

