/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import javax.annotation.Nullable;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;

public class EnderBambooBlock
extends BambooStalkBlock {
    public EnderBambooBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).sound(SoundType.BAMBOO).strength(1.0f, 1.0f).ignitedByLava().randomTicks().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).lightLevel(s -> 2).noOcclusion().dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_261764_) {
        FluidState fluidstate = p_261764_.getLevel().getFluidState(p_261764_.getClickedPos());
        if (!fluidstate.isEmpty()) {
            return null;
        }
        BlockState blockstate = p_261764_.getLevel().getBlockState(p_261764_.getClickedPos().below());
        TriState soilDecision = blockstate.canSustainPlant((BlockGetter)p_261764_.getLevel(), p_261764_.getClickedPos().below(), Direction.UP, this.defaultBlockState());
        if (soilDecision.isDefault() ? blockstate.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"ddfabfmr:ender_bamboo_plantable_on"))) : soilDecision.isTrue()) {
            if (blockstate.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO_SAPLING.get())) {
                return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0));
            }
            if (blockstate.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get())) {
                int i = (Integer)blockstate.getValue((Property)AGE) > 0 ? 1 : 0;
                return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i));
            }
            BlockState blockstate1 = p_261764_.getLevel().getBlockState(p_261764_.getClickedPos().above());
            return blockstate1.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()) ? (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)((Integer)blockstate1.getValue((Property)AGE))) : ((Block)DdfabfmrModBlocks.ENDER_BAMBOO_SAPLING.get()).defaultBlockState();
        }
        return null;
    }

    protected boolean canSurvive(BlockState p_261860_, LevelReader p_262154_, BlockPos p_261493_) {
        TriState soilDecision = p_262154_.getBlockState(p_261493_.below()).canSustainPlant((BlockGetter)p_262154_, p_261493_.below(), Direction.UP, p_261860_);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return p_262154_.getBlockState(p_261493_.below()).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"ddfabfmr:ender_bamboo_plantable_on")));
    }

    protected boolean isRandomlyTicking(BlockState p_262083_) {
        return (Integer)p_262083_.getValue((Property)STAGE) == 0;
    }

    protected void randomTick(BlockState p_261931_, ServerLevel p_261751_, BlockPos p_261616_, RandomSource p_261766_) {
        int i;
        if ((Integer)p_261931_.getValue((Property)STAGE) == 0 && p_261751_.isEmptyBlock(p_261616_.above()) && p_261751_.getRawBrightness(p_261616_.above(), 0) >= 9 && (i = this.getHeightBelowUpToMax((BlockGetter)p_261751_, p_261616_) + 1) < 16 && CommonHooks.canCropGrow((Level)p_261751_, (BlockPos)p_261616_, (BlockState)p_261931_, (p_261766_.nextInt(3) == 0 ? 1 : 0) != 0)) {
            this.growBamboo(p_261931_, (Level)p_261751_, p_261616_, p_261766_, i);
            CommonHooks.fireCropGrowPost((Level)p_261751_, (BlockPos)p_261616_, (BlockState)p_261931_);
        }
    }

    protected void growBamboo(BlockState p_261855_, Level p_262076_, BlockPos p_262109_, RandomSource p_261633_, int p_261759_) {
        BlockState blockstate = p_262076_.getBlockState(p_262109_.below());
        BlockPos blockpos = p_262109_.below(2);
        BlockState blockstate1 = p_262076_.getBlockState(blockpos);
        BambooLeaves bambooleaves = BambooLeaves.NONE;
        if (p_261759_ >= 1) {
            if (!blockstate.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()) || blockstate.getValue((Property)LEAVES) == BambooLeaves.NONE) {
                bambooleaves = BambooLeaves.SMALL;
            } else if (blockstate.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()) && blockstate.getValue((Property)LEAVES) != BambooLeaves.NONE) {
                bambooleaves = BambooLeaves.LARGE;
                if (blockstate1.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get())) {
                    p_262076_.setBlock(p_262109_.below(), (BlockState)blockstate.setValue((Property)LEAVES, (Comparable)BambooLeaves.SMALL), 3);
                    p_262076_.setBlock(blockpos, (BlockState)blockstate1.setValue((Property)LEAVES, (Comparable)BambooLeaves.NONE), 3);
                }
            }
        }
        int i = (Integer)p_261855_.getValue((Property)AGE) != 1 && !blockstate1.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()) ? 0 : 1;
        int j = !(p_261759_ >= 11 && p_261633_.nextFloat() < 0.25f || p_261759_ == 15) ? 0 : 1;
        p_262076_.setBlock(p_262109_.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)LEAVES, (Comparable)bambooleaves)).setValue((Property)STAGE, (Comparable)Integer.valueOf(j)), 3);
    }

    protected BlockState updateShape(BlockState p_261476_, LevelReader p_374219_, ScheduledTickAccess p_374048_, BlockPos p_261876_, Direction p_261512_, BlockPos p_262140_, BlockState p_262167_, RandomSource p_374194_) {
        if (!p_261476_.canSurvive(p_374219_, p_261876_)) {
            p_374048_.scheduleTick(p_261876_, (Block)this, 1);
        }
        return p_261512_ == Direction.UP && p_262167_.is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()) && (Integer)p_262167_.getValue((Property)AGE) > (Integer)p_261476_.getValue((Property)AGE) ? (BlockState)p_261476_.cycle((Property)AGE) : super.updateShape(p_261476_, p_374219_, p_374048_, p_261876_, p_261512_, p_262140_, p_262167_, p_374194_);
    }

    public void performBonemeal(ServerLevel p_261845_, RandomSource p_262034_, BlockPos p_261955_, BlockState p_261685_) {
        int i = this.getHeightAboveUpToMax((BlockGetter)p_261845_, p_261955_);
        int j = this.getHeightBelowUpToMax((BlockGetter)p_261845_, p_261955_);
        int k = i + j + 1;
        int l = 1 + p_262034_.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = p_261955_.above(i);
            BlockState blockstate = p_261845_.getBlockState(blockpos);
            if (k >= 16 || (Integer)blockstate.getValue((Property)STAGE) == 1 || !p_261845_.isEmptyBlock(blockpos.above())) {
                return;
            }
            this.growBamboo(blockstate, (Level)p_261845_, blockpos, p_262034_, k);
            ++i;
            ++k;
        }
    }

    protected int getHeightAboveUpToMax(BlockGetter p_261541_, BlockPos p_261593_) {
        int i;
        for (i = 0; i < 16 && p_261541_.getBlockState(p_261593_.above(i + 1)).is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter p_261927_, BlockPos p_261481_) {
        int i;
        for (i = 0; i < 16 && p_261927_.getBlockState(p_261481_.below(i + 1)).is((Block)DdfabfmrModBlocks.ENDER_BAMBOO.get()); ++i) {
        }
        return i;
    }
}

