/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import net.mcreator.ddfabfmr.init.DdfabfmrModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderfluverCapsuleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final int MAX_HATCH_LEVEL = 2;
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    private static final int REGULAR_HATCH_TIME_TICKS = 12000;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 300;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public EnderfluverCapsuleBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.HAT).sound(SoundType.RESIN).strength(1.0f).lightLevel(s -> 1).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void animateTick(BlockState p_222682_, Level p_222683_, BlockPos p_222684_, RandomSource p_222685_) {
        Direction direction = Direction.getRandom((RandomSource)p_222685_);
        if (direction != Direction.UP && ((Boolean)p_222682_.getValue((Property)WATERLOGGED)).booleanValue()) {
            BlockPos blockpos = p_222684_.relative(direction);
            BlockState blockstate = p_222683_.getBlockState(blockpos);
            double d0 = p_222684_.getX();
            double d1 = p_222684_.getY();
            double d2 = p_222684_.getZ();
            if (direction == Direction.DOWN) {
                d1 -= 0.05;
                d0 += p_222685_.nextDouble();
                d2 += p_222685_.nextDouble();
            } else {
                d1 += p_222685_.nextDouble() * 0.8;
                if (direction.getAxis() == Direction.Axis.X) {
                    d2 += p_222685_.nextDouble();
                    d0 = direction == Direction.EAST ? (d0 += 1.0) : (d0 += 0.05);
                } else {
                    d0 += p_222685_.nextDouble();
                    d2 = direction == Direction.SOUTH ? (d2 += 1.0) : (d2 += 0.05);
                }
            }
            p_222683_.addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> EnderfluverCapsuleBlock.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
            case Direction.NORTH -> EnderfluverCapsuleBlock.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
            case Direction.EAST -> EnderfluverCapsuleBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
            case Direction.WEST -> EnderfluverCapsuleBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, HATCH});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public int getHatchLevel(BlockState p_279125_) {
        return (Integer)p_279125_.getValue((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState p_278021_) {
        return this.getHatchLevel(p_278021_) == 2;
    }

    public void tick(BlockState p_277841_, ServerLevel p_277739_, BlockPos p_277692_, RandomSource p_277973_) {
        if (!this.isReadyToHatch(p_277841_) && ((Boolean)p_277841_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_277739_.playSound(null, p_277692_, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + p_277973_.nextFloat() * 0.2f);
            p_277739_.setBlock(p_277692_, (BlockState)p_277841_.setValue((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(p_277841_) + 1)), 2);
        } else if (((Boolean)p_277841_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_277739_.playSound(null, p_277692_, SoundEvents.SNIFFER_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + p_277973_.nextFloat() * 0.2f);
            p_277739_.destroyBlock(p_277692_, false);
            AgeableMob spawnentity = (AgeableMob)((EntityType)DdfabfmrModEntities.ENDERFLUVER.get()).create((Level)p_277739_, EntitySpawnReason.BREEDING);
            if (spawnentity != null) {
                Vec3 vec3 = p_277692_.getCenter();
                spawnentity.setBaby(true);
                spawnentity.moveTo(vec3.x(), vec3.y(), vec3.z(), Mth.wrapDegrees((float)(p_277739_.random.nextFloat() * 360.0f)), 0.0f);
                p_277739_.addFreshEntity((Entity)spawnentity);
            }
        }
    }

    public void onPlace(BlockState p_277964_, Level p_277827_, BlockPos p_277526_, BlockState p_277618_, boolean p_277819_) {
        if (((Boolean)p_277964_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_277827_.levelEvent(3009, p_277526_, 0);
        }
        int i = 12000;
        int j = i / 3;
        p_277827_.gameEvent((Holder)GameEvent.BLOCK_PLACE, p_277526_, GameEvent.Context.of((BlockState)p_277964_));
        p_277827_.scheduleTick(p_277526_, (Block)this, j + p_277827_.random.nextInt(300));
    }

    public boolean isPathfindable(BlockState p_279414_, PathComputationType p_279299_) {
        return false;
    }
}

