/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import javax.annotation.Nullable;
import net.mcreator.ddfabfmr.init.DdfabfmrModItems;
import net.mcreator.ddfabfmr.init.DdfabfmrModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class GlowInkWallTorchBlock
extends WallTorchBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public GlowInkWallTorchBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties.mapColor(MapColor.NONE).sound(SoundType.WOOD).instabreak().lightLevel(s -> 15).noCollission().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData, Player entity) {
        return new ItemStack((ItemLike)DdfabfmrModItems.GLOW_INK_TORCH.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public void animateTick(BlockState p_222660_, Level p_222661_, BlockPos p_222662_, RandomSource p_222663_) {
        Direction direction = (Direction)p_222660_.getValue((Property)FACING);
        double d0 = (double)p_222662_.getX() + 0.5;
        double d1 = (double)p_222662_.getY() + 0.7;
        double d2 = (double)p_222662_.getZ() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        Direction direction1 = direction.getOpposite();
        p_222661_.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
        p_222661_.addParticle((ParticleOptions)DdfabfmrModParticleTypes.GLOW_INK_FLAME.get(), d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_58126_) {
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = p_58126_.getLevel();
        BlockPos blockpos = p_58126_.getClickedPos();
        Direction[] adirection = p_58126_.getNearestLookingDirections();
        boolean flag = p_58126_.getLevel().getFluidState(p_58126_.getClickedPos()).getType() == Fluids.WATER;
        for (Direction direction : adirection) {
            if (!direction.getAxis().isHorizontal()) continue;
            Direction direction1 = direction.getOpposite();
            blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction1);
            if (!(blockstate = (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }
}

