/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class HangingVineBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<HangingMossBlock> CODEC = HangingVineBlock.simpleCodec(HangingMossBlock::new);
    private static final int SIDE_PADDING = 1;
    private static final VoxelShape TIP_SHAPE = Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty TIP = BlockStateProperties.TIP;

    public HangingVineBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).sound(SoundType.VINE).strength(0.2f, 0.2f).noCollission().replaceable().offsetType(BlockBehaviour.OffsetType.NONE).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP, (Comparable)Boolean.valueOf(true)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 15;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : -12012264, new Block[]{(Block)DdfabfmrModBlocks.HANGING_VINE.get()});
    }

    protected VoxelShape getShape(BlockState p_379697_, BlockGetter p_380282_, BlockPos p_379821_, CollisionContext p_379644_) {
        return (Boolean)p_379697_.getValue((Property)TIP) != false ? TIP_SHAPE : BASE_SHAPE;
    }

    protected boolean propagatesSkylightDown(BlockState p_380235_) {
        return true;
    }

    protected boolean canSurvive(BlockState p_380096_, LevelReader p_379969_, BlockPos p_380283_) {
        return this.canStayAtPosition((BlockGetter)p_379969_, p_380283_);
    }

    private boolean canStayAtPosition(BlockGetter p_379546_, BlockPos p_379355_) {
        BlockState blockstate;
        BlockPos blockpos = p_379355_.relative(Direction.UP);
        return MultifaceBlock.canAttachTo((BlockGetter)p_379546_, (Direction)Direction.UP, (BlockPos)blockpos, (BlockState)(blockstate = p_379546_.getBlockState(blockpos))) || blockstate.is((Block)this);
    }

    protected BlockState updateShape(BlockState p_380182_, LevelReader p_380219_, ScheduledTickAccess p_380011_, BlockPos p_380024_, Direction p_380101_, BlockPos p_380258_, BlockState p_379654_, RandomSource p_379547_) {
        if (!this.canStayAtPosition((BlockGetter)p_380219_, p_380024_)) {
            p_380011_.scheduleTick(p_380024_, (Block)this, 1);
        }
        return (BlockState)p_380182_.setValue((Property)TIP, (Comparable)Boolean.valueOf(!p_380219_.getBlockState(p_380024_.below()).is((Block)this)));
    }

    protected void tick(BlockState p_381085_, ServerLevel p_381014_, BlockPos p_381010_, RandomSource p_380962_) {
        if (!this.canStayAtPosition((BlockGetter)p_381014_, p_381010_)) {
            p_381014_.destroyBlock(p_381010_, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_379416_) {
        p_379416_.add(new Property[]{TIP});
    }

    public boolean isValidBonemealTarget(LevelReader p_379509_, BlockPos p_379596_, BlockState p_380331_) {
        return this.canGrowInto(p_379509_.getBlockState(this.getTip((BlockGetter)p_379509_, p_379596_).below()));
    }

    private boolean canGrowInto(BlockState p_379897_) {
        return p_379897_.isAir();
    }

    public BlockPos getTip(BlockGetter p_379440_, BlockPos p_380142_) {
        BlockState blockstate;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_380142_.mutable();
        do {
            blockpos$mutableblockpos.move(Direction.DOWN);
        } while ((blockstate = p_379440_.getBlockState((BlockPos)blockpos$mutableblockpos)).is((Block)this));
        return blockpos$mutableblockpos.relative(Direction.UP).immutable();
    }

    public boolean isBonemealSuccess(Level p_380206_, RandomSource p_380151_, BlockPos p_379719_, BlockState p_379567_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_379337_, RandomSource p_379974_, BlockPos p_379496_, BlockState p_379559_) {
        BlockPos blockpos = this.getTip((BlockGetter)p_379337_, p_379496_).below();
        if (this.canGrowInto(p_379337_.getBlockState(blockpos))) {
            p_379337_.setBlockAndUpdate(blockpos, (BlockState)p_379559_.setValue((Property)TIP, (Comparable)Boolean.valueOf(true)));
        }
    }
}

