/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ddfabfmr.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.mcreator.ddfabfmr.init.DdfabfmrModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NetheriteAnvilBlock
extends Block {
    public static final MapCodec<NetheriteAnvilBlock> CODEC = NetheriteAnvilBlock.simpleCodec(NetheriteAnvilBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape X_LEG1 = Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape X_LEG2 = Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape X_TOP = Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape Z_LEG1 = Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape Z_LEG2 = Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape Z_TOP = Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{X_LEG1, X_LEG2, X_TOP});
    private static final VoxelShape Z_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Z_LEG1, Z_LEG2, Z_TOP});
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.repair");
    private static final float FALL_DAMAGE_PER_DISTANCE = 2.0f;
    private static final int FALL_DAMAGE_MAX = 40;

    public MapCodec<NetheriteAnvilBlock> codec() {
        return CODEC;
    }

    public NetheriteAnvilBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.ANVIL).strength(50.0f, 1200.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.IRON_XYLOPHONE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_48781_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)p_48781_.getHorizontalDirection().getClockWise());
    }

    protected InteractionResult useWithoutItem(BlockState p_48804_, Level p_48805_, BlockPos p_48806_, Player p_48807_, BlockHitResult p_48809_) {
        if (!p_48805_.isClientSide) {
            p_48807_.openMenu(p_48804_.getMenuProvider(p_48805_, p_48806_));
            p_48807_.awardStat(Stats.INTERACT_WITH_ANVIL);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState p_48821_, Level p_48822_, BlockPos p_48823_) {
        return new SimpleMenuProvider((p_48785_, p_48786_, p_48787_) -> new AnvilMenu(p_48785_, p_48786_, ContainerLevelAccess.create((Level)p_48822_, (BlockPos)p_48823_)), CONTAINER_TITLE);
    }

    protected VoxelShape getShape(BlockState p_48816_, BlockGetter p_48817_, BlockPos p_48818_, CollisionContext p_48819_) {
        Direction direction = (Direction)p_48816_.getValue(FACING);
        return direction.getAxis() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    @Nullable
    public static BlockState damage(BlockState p_48825_) {
        if (p_48825_.is((Block)DdfabfmrModBlocks.NETHERITE_ANVIL.get())) {
            return (BlockState)((Block)DdfabfmrModBlocks.NETHERITE_ANVIL.get()).defaultBlockState().setValue(FACING, (Comparable)((Direction)p_48825_.getValue(FACING)));
        }
        return p_48825_.is((Block)DdfabfmrModBlocks.NETHERITE_ANVIL.get()) ? (BlockState)((Block)DdfabfmrModBlocks.NETHERITE_ANVIL.get()).defaultBlockState().setValue(FACING, (Comparable)((Direction)p_48825_.getValue(FACING))) : null;
    }

    protected BlockState rotate(BlockState p_48811_, Rotation p_48812_) {
        return (BlockState)p_48811_.setValue(FACING, (Comparable)p_48812_.rotate((Direction)p_48811_.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_48814_) {
        p_48814_.add(new Property[]{FACING});
    }

    protected boolean isPathfindable(BlockState p_48799_, PathComputationType p_48802_) {
        return false;
    }
}

